/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.config;

import java.text.DecimalFormat;
import java.util.Random;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.engine.event.LoopIterationListener;
import org.apache.jmeter.engine.util.NoConfigMerge;
import org.apache.jmeter.engine.util.NoThreadClone;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomVariableConfig
extends ConfigTestElement
implements TestBean,
LoopIterationListener,
NoThreadClone,
NoConfigMerge {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 233L;
    private String minimumValue;
    private String maximumValue;
    private String variableName;
    private String outputFormat;
    private String randomSeed;
    private boolean perThread;
    private Random globalRandom = null;
    private transient ThreadLocal<Random> perThreadRandom = this.initThreadLocal();
    private int n;
    private long minimum;

    private ThreadLocal<Random> initThreadLocal() {
        return new ThreadLocal<Random>(){

            @Override
            protected Random initialValue() {
                RandomVariableConfig.this.init();
                return new Random(RandomVariableConfig.this.getRandomSeedAsLong());
            }
        };
    }

    private Object readResolve() {
        this.perThreadRandom = this.initThreadLocal();
        return this;
    }

    private void init() {
        String minAsString = this.getMinimumValue();
        this.minimum = NumberUtils.toLong((String)minAsString);
        String maxAsString = this.getMaximumValue();
        long maximum = NumberUtils.toLong((String)maxAsString);
        long rangeL = maximum - this.minimum + 1L;
        if (this.minimum >= maximum) {
            log.error("maximum(" + maxAsString + ") must be > minimum" + minAsString + ")");
            this.n = 0;
            return;
        }
        if (rangeL > Integer.MAX_VALUE || rangeL <= 0L) {
            log.warn("maximum(" + maxAsString + ") - minimum" + minAsString + ") must be <=" + Integer.MAX_VALUE);
            rangeL = Integer.MAX_VALUE;
        }
        this.n = (int)rangeL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterationStart(LoopIterationEvent iterEvent) {
        Random randGen = null;
        if (this.getPerThread()) {
            randGen = this.perThreadRandom.get();
        } else {
            RandomVariableConfig randomVariableConfig = this;
            synchronized (randomVariableConfig) {
                if (this.globalRandom == null) {
                    this.init();
                    this.globalRandom = new Random(this.getRandomSeedAsLong());
                }
                randGen = this.globalRandom;
            }
        }
        if (this.n <= 0) {
            return;
        }
        long nextRand = this.minimum + (long)randGen.nextInt(this.n);
        JMeterVariables variables = JMeterContextService.getContext().getVariables();
        variables.put(this.getVariableName(), this.formatNumber(nextRand));
    }

    private String formatNumber(long value) {
        String format = this.getOutputFormat();
        if (format != null && format.length() > 0) {
            try {
                DecimalFormat myFormatter = new DecimalFormat(format);
                return myFormatter.format(value);
            }
            catch (NumberFormatException ignored) {
                log.warn("Exception formatting value:" + value + " at format:" + format + ", using default");
            }
            catch (IllegalArgumentException ignored) {
                log.warn("Exception formatting value:" + value + " at format:" + format + ", using default");
            }
        }
        return Long.toString(value);
    }

    public synchronized String getMinimumValue() {
        return this.minimumValue;
    }

    public synchronized void setMinimumValue(String minValue) {
        this.minimumValue = minValue;
    }

    public synchronized String getMaximumValue() {
        return this.maximumValue;
    }

    public synchronized void setMaximumValue(String maxvalue) {
        this.maximumValue = maxvalue;
    }

    public synchronized String getVariableName() {
        return this.variableName;
    }

    public synchronized void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public synchronized String getRandomSeed() {
        return this.randomSeed;
    }

    private synchronized long getRandomSeedAsLong() {
        long seed = 0L;
        if (this.randomSeed.length() == 0) {
            seed = System.currentTimeMillis();
        } else {
            try {
                seed = Long.parseLong(this.randomSeed);
            }
            catch (NumberFormatException e) {
                seed = System.currentTimeMillis();
                log.warn("Cannot parse seed " + e.getLocalizedMessage());
            }
        }
        return seed;
    }

    public synchronized void setRandomSeed(String randomSeed) {
        this.randomSeed = randomSeed;
    }

    public synchronized boolean getPerThread() {
        return this.perThread;
    }

    public synchronized void setPerThread(boolean perThread) {
        this.perThread = perThread;
    }

    public synchronized String getOutputFormat() {
        return this.outputFormat;
    }

    public synchronized void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }
}

