/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.RequestView;
import org.apache.jorphan.gui.GuiUtils;

public class RequestViewRaw
implements RequestView {
    static final String KEY_LABEL = "view_results_table_request_tab_raw";
    private JTextArea sampleDataField;
    private JPanel paneRaw;

    public void init() {
        this.paneRaw = new JPanel(new BorderLayout(0, 5));
        this.sampleDataField = new JTextArea();
        this.sampleDataField.setEditable(false);
        this.sampleDataField.setLineWrap(true);
        this.sampleDataField.setWrapStyleWord(true);
        this.paneRaw.add(GuiUtils.makeScrollPane((Component)this.sampleDataField));
    }

    public void clearData() {
        this.sampleDataField.setText("");
    }

    public void setSamplerResult(Object objectResult) {
        if (objectResult instanceof SampleResult) {
            SampleResult sampleResult = (SampleResult)objectResult;
            String sd = sampleResult.getSamplerData();
            if (sd != null) {
                String rh = sampleResult.getRequestHeaders();
                if (rh != null && rh.length() > 0) {
                    StringBuilder sb = new StringBuilder(sd.length() + rh.length() + 20);
                    sb.append(sd);
                    sb.append("\n");
                    sb.append(JMeterUtils.getResString((String)"view_results_request_headers"));
                    sb.append("\n");
                    sb.append(rh);
                    sd = sb.toString();
                }
                this.sampleDataField.setText(sd);
            } else {
                this.sampleDataField.setText(JMeterUtils.getResString((String)"view_results_table_request_raw_nodata"));
            }
        }
    }

    public JPanel getPanel() {
        return this.paneRaw;
    }

    public String getLabel() {
        return JMeterUtils.getResString((String)KEY_LABEL);
    }
}

