/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.sampler;

import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class TestAction
extends AbstractSampler {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 240L;
    public static final int STOP = 0;
    public static final int PAUSE = 1;
    public static final int STOP_NOW = 2;
    public static final int THREAD = 0;
    public static final int TEST = 2;
    private static final String TARGET = "ActionProcessor.target";
    private static final String ACTION = "ActionProcessor.action";
    private static final String DURATION = "ActionProcessor.duration";

    public SampleResult sample(Entry e) {
        JMeterContext context = JMeterContextService.getContext();
        int target = this.getTarget();
        int action = this.getAction();
        if (action == 1) {
            this.pause(this.getDurationAsString());
        } else if (action == 0 || action == 2) {
            if (target == 0) {
                log.info("Stopping current thread");
                context.getThread().stop();
            } else if (target == 2) {
                if (action == 2) {
                    log.info("Stopping all threads now");
                    context.getEngine().stopTest();
                } else {
                    log.info("Stopping all threads");
                    context.getEngine().askThreadsToStop();
                }
            }
        }
        return null;
    }

    private void pause(String mili_s) {
        int milis;
        try {
            milis = Integer.parseInt(mili_s);
        }
        catch (NumberFormatException e) {
            log.warn("Could not create number from " + mili_s);
            milis = 0;
        }
        try {
            Thread.sleep(milis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setTarget(int target) {
        this.setProperty((JMeterProperty)new IntegerProperty(TARGET, target));
    }

    public int getTarget() {
        return this.getPropertyAsInt(TARGET);
    }

    public void setAction(int action) {
        this.setProperty((JMeterProperty)new IntegerProperty(ACTION, action));
    }

    public int getAction() {
        return this.getPropertyAsInt(ACTION);
    }

    public void setDuration(String duration) {
        this.setProperty((JMeterProperty)new StringProperty(DURATION, duration));
    }

    public String getDurationAsString() {
        return this.getPropertyAsString(DURATION);
    }
}

