/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.assertions.gui;

import java.awt.BorderLayout;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.jmeter.assertions.XPathAssertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.assertions.gui.XMLConfPanel;
import org.apache.jmeter.assertions.gui.XPathPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class XPathAssertionGui
extends AbstractAssertionGui {
    private static final long serialVersionUID = 240L;
    private XPathPanel xpath;
    private XMLConfPanel xml;

    public XPathAssertionGui() {
        this.init();
    }

    public String getLabelResource() {
        return "xpath_assertion_title";
    }

    public TestElement createTestElement() {
        XPathAssertion el = new XPathAssertion();
        this.modifyTestElement((TestElement)el);
        return el;
    }

    public String getXPathAttributesTitle() {
        return JMeterUtils.getResString((String)"xpath_assertion_test");
    }

    public void configure(TestElement el) {
        super.configure(el);
        XPathAssertion assertion = (XPathAssertion)el;
        this.xpath.setXPath(assertion.getXPathString());
        this.xpath.setNegated(assertion.isNegated());
        this.xml.configure(assertion);
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 3, 1));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel());
        JPanel sizePanel = new JPanel(new BorderLayout());
        sizePanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        sizePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.getXPathAttributesTitle()));
        this.xpath = new XPathPanel();
        sizePanel.add(this.xpath);
        this.xml = new XMLConfPanel();
        this.xml.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"xpath_assertion_option")));
        this.add(this.xml);
        this.add(sizePanel);
    }

    public void modifyTestElement(TestElement el) {
        super.configureTestElement(el);
        if (el instanceof XPathAssertion) {
            XPathAssertion assertion = (XPathAssertion)el;
            assertion.setNegated(this.xpath.isNegated());
            assertion.setXPathString(this.xpath.getXPath());
            this.xml.modifyTestElement(assertion);
        }
    }

    public void clearGui() {
        super.clearGui();
        this.xpath.setXPath("/");
        this.xpath.setNegated(false);
        this.xml.setDefaultValues();
    }
}

