/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.extractor;

import java.util.List;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMBuilder;
import jodd.lagarto.dom.Node;
import jodd.lagarto.dom.NodeSelector;
import org.apache.jmeter.extractor.Extractor;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jorphan.util.JOrphanUtils;

public class JoddExtractor
implements Extractor {
    private static final long serialVersionUID = -7235814605293262972L;
    private static final String CACHE_KEY_PREFIX = JoddExtractor.class.getName() + "_PARSED_BODY";

    @Override
    public int extract(String expression, String attribute, int matchNumber, String inputString, List<String> result, int found, String cacheKey) {
        Document doc;
        LagartoDOMBuilder domBuilder;
        NodeSelector nodeSelector = null;
        if (cacheKey != null) {
            nodeSelector = (NodeSelector)JMeterContextService.getContext().getSamplerContext().get(CACHE_KEY_PREFIX + cacheKey);
            if (nodeSelector == null) {
                domBuilder = new LagartoDOMBuilder();
                doc = domBuilder.parse(inputString);
                nodeSelector = new NodeSelector((Node)doc);
                JMeterContextService.getContext().getSamplerContext().put(CACHE_KEY_PREFIX + cacheKey, nodeSelector);
            }
        } else {
            domBuilder = new LagartoDOMBuilder();
            doc = domBuilder.parse(inputString);
            nodeSelector = new NodeSelector((Node)doc);
        }
        List elements = nodeSelector.select(expression);
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            Node element = (Node)elements.get(i);
            if (matchNumber > 0 && found == matchNumber) break;
            result.add(this.extractValue(attribute, element));
            ++found;
        }
        return found;
    }

    private String extractValue(String attribute, Node element) {
        if (!JOrphanUtils.isBlank((String)attribute)) {
            return element.getAttribute(attribute);
        }
        return element.getTextContent().trim();
    }
}

