/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.querybuilder;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.arq.querybuilder.rewriters.AbstractRewriter;
import org.apache.jena.arq.querybuilder.rewriters.PathRewriter;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.lang.arq.ARQParser;
import org.apache.jena.sparql.lang.arq.ParseException;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathParser;
import org.apache.jena.sparql.path.PathVisitor;
import org.apache.jena.sparql.syntax.TripleCollectorMark;
import org.apache.jena.sparql.util.NodeFactoryExtra;
import org.apache.jena.vocabulary.RDF;

public class Converters {
    private Converters() {
    }

    private static boolean isCollection(Object o) {
        Predicate<String> isLiteralCollection = s -> s.charAt(0) == '(' && s.charAt(s.length() - 1) == ')';
        return o != null && (o instanceof Collection || o instanceof String && isLiteralCollection.test(((String)o).trim()));
    }

    public static Node checkVar(Node n) {
        if (n.isVariable()) {
            return Var.alloc((Node)n);
        }
        return n;
    }

    public static Node makeLiteral(Object o) {
        RDFDatatype dt = TypeMapper.getInstance().getTypeByValue(o);
        if (dt == null) {
            String msg = "No TypeDef defined for %s. Use TypeMapper.getInstance().register() to register one or use makeLiteral() method in query builder instance.";
            throw new IllegalArgumentException(String.format(msg, o.getClass()));
        }
        return NodeFactory.createLiteralByValue((Object)o, (RDFDatatype)dt);
    }

    public static Node makeLiteral(String value, String typeUri) {
        Object dt = TypeMapper.getInstance().getTypeByName(typeUri);
        if (dt == null) {
            dt = new BaseDatatype(typeUri){

                public boolean isValidValue(Object valueForm) {
                    return false;
                }

                public Object parse(String lexicalForm) throws DatatypeFormatException {
                    RDFDatatype dt = TypeMapper.getInstance().getTypeByName(this.uri);
                    if (dt == null) {
                        throw new DatatypeFormatException("no registered Datatype for " + this.uri);
                    }
                    return dt.parse(lexicalForm);
                }
            };
        } else {
            dt.parse(value);
        }
        return NodeFactory.createLiteralDT((String)value, (RDFDatatype)dt);
    }

    public static Node makeNode(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof FrontsNode) {
            return Converters.checkVar(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return Converters.checkVar((Node)o);
        }
        if (o instanceof String) {
            try {
                return Converters.checkVar(NodeFactoryExtra.parseNode((String)((String)o), (PrefixMap)PrefixMapFactory.create((PrefixMapping)pMapping)));
            }
            catch (RiotException riotException) {
                // empty catch block
            }
        }
        return Converters.makeLiteral(o);
    }

    public static Object makeNodeOrPath(Object o, PrefixMapping pMapping) {
        if (o == null) {
            return Node.ANY;
        }
        if (o instanceof Path) {
            return o;
        }
        if (o instanceof FrontsNode) {
            return Converters.checkVar(((FrontsNode)o).asNode());
        }
        if (o instanceof Node) {
            return Converters.checkVar((Node)o);
        }
        if (o instanceof String) {
            try {
                Path p = PathParser.parse((String)((String)o), (PrefixMapping)pMapping);
                if (p instanceof P_Link) {
                    return ((P_Link)p).getNode();
                }
                return p;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Converters.makeNode(o, pMapping);
    }

    public static Var makeVar(Object o) throws ARQInternalErrorException {
        if (o == null) {
            return Var.ANON;
        }
        if (o instanceof Var) {
            return (Var)o;
        }
        Var retval = null;
        retval = o instanceof FrontsNode ? Var.alloc((Node)((FrontsNode)o).asNode()) : (o instanceof Node ? Var.alloc((Node)((Node)o)) : (o instanceof ExprVar ? Var.alloc((ExprVar)((ExprVar)o)) : Var.alloc((String)Var.canonical((String)o.toString()))));
        if ("*".equals(Var.canonical((String)retval.toString()))) {
            return null;
        }
        return retval;
    }

    public static String quoted(String q) {
        int qt = q.indexOf(34);
        int sqt = q.indexOf("'");
        if (qt == -1) {
            qt = Integer.MAX_VALUE;
        }
        if (sqt == -1) {
            sqt = Integer.MAX_VALUE;
        }
        if (qt <= sqt) {
            return String.format("'%s'", q);
        }
        return String.format("\"%s\"", q);
    }

    public static Collection<Node> makeValueNodes(Iterator<?> iter, PrefixMapping prefixMapping) {
        if (iter == null || !iter.hasNext()) {
            return null;
        }
        ArrayList<Node> values = new ArrayList<Node>();
        while (iter.hasNext()) {
            Object o = iter.next();
            if (o == null) {
                values.add(null);
                continue;
            }
            values.add(Converters.makeNode(o, prefixMapping));
        }
        return values;
    }

    private static void gatherTriples(ReadableTripleCollectorMark collector, Object s, Object p, Object o, PrefixMapping prefixMapping) {
        Node sNode = null;
        Object pNode = null;
        Node oNode = null;
        Function<Object, Node> processNode = n -> {
            if (Converters.isCollection(n)) {
                int mark = collector.mark();
                Converters.gatherTriples(collector, n, prefixMapping);
                return collector.getSubject(mark);
            }
            return Converters.makeNode(n, prefixMapping);
        };
        sNode = processNode.apply(s);
        if (Converters.isCollection(p)) {
            int mark = collector.mark();
            Converters.gatherTriples(collector, p, prefixMapping);
            pNode = collector.getSubject(mark);
        } else {
            pNode = Converters.makeNodeOrPath(p, prefixMapping);
        }
        oNode = processNode.apply(o);
        if (pNode instanceof Path) {
            collector.addTriplePath(new TriplePath(sNode, (Path)pNode, oNode));
        } else {
            collector.addTriple(Triple.create((Node)sNode, (Node)((Node)pNode), (Node)oNode));
        }
    }

    public static List<TriplePath> makeTriplePaths(Object s, Object p, Object o, PrefixMapping prefixMapping) {
        ConvertersTriplePathCollector result = new ConvertersTriplePathCollector();
        Converters.gatherTriples(result, s, p, o, prefixMapping);
        return result.result;
    }

    public static List<Triple> makeTriples(Object s, Object p, Object o, PrefixMapping prefixMapping) {
        ConvertersTripleCollector result = new ConvertersTripleCollector();
        Converters.gatherTriples(result, s, p, o, prefixMapping);
        return result.result;
    }

    private static void gatherTriples(ReadableTripleCollectorMark collector, Object collection, PrefixMapping prefixMapping) {
        if (collection instanceof Collection) {
            Node previous = null;
            for (Object obj : (Collection)collection) {
                Node current = NodeFactory.createBlankNode();
                if (previous != null) {
                    collector.addTriple(Triple.create(previous, (Node)RDF.rest.asNode(), (Node)current));
                }
                if (Converters.isCollection(obj)) {
                    int mark = collector.mark();
                    Converters.gatherTriples(collector, obj, prefixMapping);
                    collector.addTriple(Triple.create((Node)current, (Node)RDF.first.asNode(), (Node)collector.getSubject(mark)));
                } else {
                    collector.addTriple(Triple.create((Node)current, (Node)RDF.first.asNode(), (Node)Converters.makeNode(obj, prefixMapping)));
                }
                previous = current;
            }
            collector.addTriple(Triple.create(previous, (Node)RDF.rest.asNode(), (Node)RDF.nil.asNode()));
        } else {
            String parserInput = collection.toString().trim();
            ARQParser parser = new ARQParser((Reader)new StringReader(parserInput));
            int mark = collector.mark();
            try {
                parser.CollectionPath((TripleCollectorMark)collector);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Unable to parse: %s", collection), e);
            }
            collector.rewriteFrom(mark);
        }
    }

    public static List<Triple> makeCollectionTriples(Object collection, PrefixMapping prefixMapping) {
        ConvertersTripleCollector collector = new ConvertersTripleCollector();
        Converters.gatherTriples(collector, collection, prefixMapping);
        return collector.result;
    }

    public static List<TriplePath> makeCollectionTriplePaths(Object n, PrefixMapping prefixMapping) {
        ConvertersTriplePathCollector collector = new ConvertersTriplePathCollector();
        Converters.gatherTriples(collector, n, prefixMapping);
        return collector.result;
    }

    static interface ReadableTripleCollectorMark
    extends TripleCollectorMark {
        public Node getSubject(int var1);

        public void rewriteFrom(int var1);
    }

    private static class ConvertersTriplePathCollector
    implements ReadableTripleCollectorMark {
        List<TriplePath> result = new ArrayList<TriplePath>();

        private ConvertersTriplePathCollector() {
        }

        public void addTriple(Triple t) {
            this.result.add(new TriplePath(t));
        }

        public void addTriplePath(TriplePath tPath) {
            this.result.add(tPath);
        }

        public int mark() {
            return this.result.size();
        }

        public void addTriple(int index, Triple t) {
            this.result.add(index, new TriplePath(t));
        }

        public void addTriplePath(int index, TriplePath tPath) {
            this.result.add(index, tPath);
        }

        @Override
        public Node getSubject(int mark) {
            return this.result.get(mark).getSubject();
        }

        @Override
        public void rewriteFrom(int mark) {
            HashMap<Var, Node> values = new HashMap<Var, Node>();
            TripleRewriter rewriter = new TripleRewriter(values);
            for (int i = mark; i < this.mark(); ++i) {
                this.result.set(i, rewriter.rewrite(this.result.get(i)));
            }
        }
    }

    private static class ConvertersTripleCollector
    implements ReadableTripleCollectorMark {
        List<Triple> result = new ArrayList<Triple>();

        private ConvertersTripleCollector() {
        }

        public void addTriple(Triple t) {
            this.result.add(t);
        }

        public void addTriplePath(TriplePath tPath) {
            throw new IllegalArgumentException("Path is not allowed in a Triple");
        }

        public int mark() {
            return this.result.size();
        }

        public void addTriple(int index, Triple t) {
            this.result.add(index, t);
        }

        public void addTriplePath(int index, TriplePath tPath) {
            throw new IllegalArgumentException("Path is not allowed in a Triple");
        }

        @Override
        public Node getSubject(int mark) {
            return this.result.get(mark).getSubject();
        }

        @Override
        public void rewriteFrom(int mark) {
            HashMap<Var, Node> values = new HashMap<Var, Node>();
            TripleRewriter rewriter = new TripleRewriter(values);
            for (int i = mark; i < this.mark(); ++i) {
                this.result.set(i, rewriter.rewrite(this.result.get(i)));
            }
        }
    }

    private static class TripleRewriter
    extends AbstractRewriter<Node> {
        private PathRewriter pathRewriter;

        protected TripleRewriter(Map<Var, Node> values) {
            super(values);
            this.pathRewriter = new PathRewriter(values){

                @Override
                protected Node changeNode(Node n) {
                    return this.changeNode(n);
                }
            };
        }

        @Override
        protected Node changeNode(Node n) {
            if (n == null) {
                return n;
            }
            if (n.isVariable() && n.toString().startsWith("??")) {
                Var key = Var.alloc((Node)n);
                Node result = (Node)this.values.get(key);
                if (result == null) {
                    result = NodeFactory.createBlankNode();
                    this.values.put(key, result);
                }
                return result;
            }
            return n;
        }

        @Override
        public TriplePath rewrite(TriplePath t) {
            if (t.getPath() == null) {
                return new TriplePath(Triple.create((Node)this.changeNode(t.getSubject()), (Node)this.changeNode(t.getPredicate()), (Node)this.changeNode(t.getObject())));
            }
            t.getPath().visit((PathVisitor)this.pathRewriter);
            return new TriplePath(this.changeNode(t.getSubject()), (Path)this.pathRewriter.getResult(), this.changeNode(t.getObject()));
        }
    }
}

