/*
 * Decompiled with CFR 0.152.
 */
package arq.examples.riot;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.adapters.RDFReaderRIOT;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.builders.BuilderGraph;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.util.iterator.ExtendedIterator;

public class ExRIOT6_AddNewReader {
    public static void main(String ... argv) {
        Lang lang = LangBuilder.create((String)"SSE", (String)"text/x-sse").addFileExtensions(new String[]{"rsse"}).build();
        RDFLanguages.register((Lang)lang);
        SSEReaderFactory factory = new SSEReaderFactory();
        RDFParserRegistry.registerLangTriples((Lang)lang, (ReaderRIOTFactory)factory);
        String x = "(graph (<s> <p1> 123) (<s> <p2> 456) )";
        Model model = ModelFactory.createDefaultModel();
        RDFDataMgr.read((Model)model, (StringReader)new StringReader(x), (String)"http://example/", (Lang)lang);
        RDFDataMgr.write((OutputStream)System.out, (Model)model, (Lang)Lang.TTL);
    }

    static {
        LogCtl.setLogging();
    }

    static class SSEReaderFactory
    implements ReaderRIOTFactory {
        SSEReaderFactory() {
        }

        public ReaderRIOT create(Lang language, ParserProfile profile) {
            return new SSEReader();
        }
    }

    public static class RDFReaderSSE
    extends RDFReaderRIOT {
        public RDFReaderSSE() {
            super("SSE");
        }
    }

    static class SSEReader
    implements ReaderRIOT {
        SSEReader() {
        }

        public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            Item item = SSE.parse((InputStream)in);
            this.read(item, baseURI, ct, output, context);
        }

        public void read(Reader in, String baseURI, ContentType ct, StreamRDF output, Context context) {
            Item item = SSE.parse((Reader)in);
            this.read(item, baseURI, ct, output, context);
        }

        private void read(Item item, String baseURI, ContentType ct, StreamRDF output, Context context) {
            Graph graph = BuilderGraph.buildGraph((Item)item);
            ExtendedIterator iter = graph.find(null, null, null);
            while (iter.hasNext()) {
                output.triple((Triple)iter.next());
            }
        }
    }
}

