/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.digitalocean2.features;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import java.io.Closeable;
import java.net.URI;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.PagedIterable;
import org.jclouds.digitalocean2.DigitalOcean2Api;
import org.jclouds.digitalocean2.domain.Key;
import org.jclouds.digitalocean2.domain.internal.PaginatedCollection;
import org.jclouds.digitalocean2.domain.options.ListOptions;
import org.jclouds.digitalocean2.functions.BaseToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.json.Json;
import org.jclouds.oauth.v2.filters.OAuthFilter;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.binders.BindToJsonPayload;

@Path(value="/account/keys")
@RequestFilters(value={OAuthFilter.class})
@Consumes(value={"application/json"})
public interface KeyApi
extends Closeable {
    @Named(value="key:list")
    @GET
    @ResponseParser(value=ParseKeys.class)
    @Transform(value=ParseKeys.ToPagedIterable.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Key> list();

    @Named(value="key:list")
    @GET
    @ResponseParser(value=ParseKeys.class)
    @Fallback(value=Fallbacks.EmptyIterableWithMarkerOnNotFoundOr404.class)
    public IterableWithMarker<Key> list(ListOptions var1);

    @Named(value="key:create")
    @POST
    @Produces(value={"application/json"})
    @SelectJson(value={"ssh_key"})
    @MapBinder(value=BindToJsonPayload.class)
    public Key create(@PayloadParam(value="name") String var1, @PayloadParam(value="public_key") String var2);

    @Named(value="key:get")
    @GET
    @SelectJson(value={"ssh_key"})
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Key get(@PathParam(value="id") int var1);

    @Named(value="key:get")
    @GET
    @SelectJson(value={"ssh_key"})
    @Path(value="/{fingerprint}")
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Key get(@PathParam(value="fingerprint") String var1);

    @Named(value="key:update")
    @PUT
    @Produces(value={"application/json"})
    @SelectJson(value={"ssh_key"})
    @Path(value="/{id}")
    @MapBinder(value=BindToJsonPayload.class)
    public Key update(@PathParam(value="id") int var1, @PayloadParam(value="name") String var2);

    @Named(value="key:update")
    @PUT
    @Produces(value={"application/json"})
    @SelectJson(value={"ssh_key"})
    @Path(value="/{fingerprint}")
    @MapBinder(value=BindToJsonPayload.class)
    public Key update(@PathParam(value="fingerprint") String var1, @PayloadParam(value="name") String var2);

    @Named(value="key:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="id") int var1);

    @Named(value="key:delete")
    @DELETE
    @Path(value="/{fingerprint}")
    @Fallback(value=Fallbacks.VoidOnNotFoundOr404.class)
    public void delete(@PathParam(value="fingerprint") String var1);

    public static final class ParseKeys
    extends ParseJson<Keys> {
        @Inject
        ParseKeys(Json json) {
            super(json, TypeLiteral.get(Keys.class));
        }

        private static class ToPagedIterable
        extends BaseToPagedIterable<Key, ListOptions> {
            @Inject
            ToPagedIterable(DigitalOcean2Api api, Function<URI, ListOptions> linkToOptions) {
                super(api, linkToOptions);
            }

            @Override
            protected IterableWithMarker<Key> fetchPageUsingOptions(ListOptions options, Optional<Object> arg0) {
                return this.api.keyApi().list(options);
            }
        }

        private static class Keys
        extends PaginatedCollection<Key> {
            @ConstructorProperties(value={"ssh_keys", "meta", "links"})
            public Keys(List<Key> items, PaginatedCollection.Meta meta, PaginatedCollection.Links links) {
                super(items, meta, links);
            }
        }
    }
}

