/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.location;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationScope;
import org.jclouds.location.suppliers.ImplicitLocationSupplier;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.VDC;

@Singleton
public class DefaultVDC
implements ImplicitLocationSupplier {
    private final Supplier<Set<? extends Location>> locationsSupplier;
    private final IsDefaultVDC isDefaultVDC;

    @Inject
    DefaultVDC(@Memoized Supplier<Set<? extends Location>> locationsSupplier, IsDefaultVDC isDefaultVDC) {
        this.locationsSupplier = (Supplier)Preconditions.checkNotNull(locationsSupplier, (Object)"locationsSupplierSupplier");
        this.isDefaultVDC = (IsDefaultVDC)Preconditions.checkNotNull((Object)isDefaultVDC, (Object)"isDefaultVDC");
    }

    public Location get() {
        return (Location)Iterables.find((Iterable)((Iterable)this.locationsSupplier.get()), (Predicate)this.isDefaultVDC);
    }

    @Singleton
    public static class IsDefaultVDC
    implements Predicate<Location> {
        private final Supplier<ReferenceType> defaultVDCSupplier;

        @Inject
        IsDefaultVDC(@VDC Supplier<ReferenceType> defaultVDCSupplier) {
            this.defaultVDCSupplier = (Supplier)Preconditions.checkNotNull(defaultVDCSupplier, (Object)"defaultVDCSupplier");
        }

        public boolean apply(Location input) {
            ReferenceType defaultVDC = (ReferenceType)this.defaultVDCSupplier.get();
            return input.getScope() == LocationScope.ZONE && input.getId().equals(defaultVDC.getHref().toASCIIString());
        }

        public String toString() {
            return "isDefaultVDC()";
        }
    }
}

