/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.VCloudApi;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VDC;

@Singleton
public class VDCsInOrg
implements Function<Org, Iterable<VDC>> {
    @Resource
    public Logger logger = Logger.NULL;
    private final VCloudApi aclient;

    @Inject
    VDCsInOrg(VCloudApi aclient) {
        this.aclient = aclient;
    }

    public Iterable<VDC> apply(Org org) {
        return Iterables.transform(org.getVDCs().values(), (Function)new Function<ReferenceType, VDC>(){

            public VDC apply(ReferenceType from) {
                return VDCsInOrg.this.aclient.getVDCApi().getVDC(from.getHref());
            }
        });
    }
}

