/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;

public class CatalogItemImpl
extends ReferenceTypeImpl
implements CatalogItem {
    private final String description;
    private final ReferenceType entity;
    private final Map<String, String> properties = Maps.newLinkedHashMap();

    public CatalogItemImpl(String name, URI id, @Nullable String description, ReferenceType entity, Map<String, String> properties) {
        super(name, "application/vnd.vmware.vcloud.catalogItem+xml", id);
        this.description = description;
        this.entity = (ReferenceType)Preconditions.checkNotNull((Object)entity, (Object)"entity");
        this.properties.putAll((Map)Preconditions.checkNotNull(properties, (Object)"properties"));
    }

    @Override
    public String getType() {
        return "application/vnd.vmware.vcloud.catalogItem+xml";
    }

    @Override
    public ReferenceType getEntity() {
        return this.entity;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String toString() {
        return "CatalogItemImpl [id=" + this.getHref() + ", name=" + this.getName() + ", type=" + this.getType() + ", description=" + this.getDescription() + ", entity=" + this.entity + ", properties=" + this.properties + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + (this.properties == null ? 0 : ((Object)this.properties).hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogItemImpl other = (CatalogItemImpl)obj;
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !((Object)this.properties).equals(other.properties));
    }
}

