/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.logging.Logger;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.VirtualSystem;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException
implements Function<VAppTemplate, Envelope> {
    @Resource
    protected Logger logger = Logger.NULL;
    private final LoadingCache<URI, Envelope> envelopes;

    @Inject
    protected ValidateVAppTemplateAndReturnEnvelopeOrThrowIllegalArgumentException(LoadingCache<URI, Envelope> envelopes) {
        this.envelopes = (LoadingCache)Preconditions.checkNotNull(envelopes, (Object)"envelopes");
    }

    public Envelope apply(VAppTemplate from) {
        Preconditions.checkArgument((from.getChildren().size() == 1 ? 1 : 0) != 0, (String)"multiple vms are not supported: %s", (Object[])new Object[]{from});
        Preconditions.checkArgument((from.getNetworkSection().getNetworks().size() == 1 ? 1 : 0) != 0, (String)"multiple network connections are not supported: %s", (Object[])new Object[]{from});
        Preconditions.checkArgument((boolean)from.isOvfDescriptorUploaded(), (String)"ovf descriptor is not uploaded: %s", (Object[])new Object[]{from});
        Envelope ovf = this.getOVFForVAppTemplateAndValidate(from);
        return ovf;
    }

    private Envelope getOVFForVAppTemplateAndValidate(VAppTemplate from) throws IllegalArgumentException {
        Envelope ovf;
        try {
            ovf = (Envelope)this.envelopes.get((Object)from.getHref());
            Preconditions.checkArgument((((VirtualSystem)ovf.getVirtualSystem()).getVirtualHardwareSections().size() > 0 ? 1 : 0) != 0, (String)"no hardware sections exist in ovf %s", (Object[])new Object[]{ovf});
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("no ovf envelope found for: " + from, e);
        }
        return ovf;
    }
}

