/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.compute.domain.Hardware;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.NodeMetadataBuilder;
import org.jclouds.compute.functions.GroupNamingConvention;
import org.jclouds.compute.util.ComputeServiceUtils;
import org.jclouds.domain.Credentials;
import org.jclouds.domain.LoginCredentials;
import org.jclouds.logging.Logger;
import org.jclouds.util.InetAddresses2;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.compute.util.VCloudComputeUtils;
import org.jclouds.vcloud.domain.Status;
import org.jclouds.vcloud.domain.VApp;

@Singleton
public class VAppToNodeMetadata
implements Function<VApp, NodeMetadata> {
    @Resource
    protected static Logger logger = Logger.NULL;
    protected final FindLocationForResource findLocationForResourceInVDC;
    protected final Function<VApp, Hardware> hardwareForVApp;
    protected final Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus;
    protected final Map<String, Credentials> credentialStore;
    protected final GroupNamingConvention nodeNamingConvention;

    @Inject
    protected VAppToNodeMetadata(Map<Status, NodeMetadata.Status> vAppStatusToNodeStatus, Map<String, Credentials> credentialStore, FindLocationForResource findLocationForResourceInVDC, Function<VApp, Hardware> hardwareForVApp, GroupNamingConvention.Factory namingConvention) {
        this.nodeNamingConvention = ((GroupNamingConvention.Factory)Preconditions.checkNotNull((Object)namingConvention, (Object)"namingConvention")).createWithoutPrefix();
        this.hardwareForVApp = (Function)Preconditions.checkNotNull(hardwareForVApp, (Object)"hardwareForVApp");
        this.findLocationForResourceInVDC = (FindLocationForResource)Preconditions.checkNotNull((Object)findLocationForResourceInVDC, (Object)"findLocationForResourceInVDC");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.vAppStatusToNodeStatus = (Map)Preconditions.checkNotNull(vAppStatusToNodeStatus, (Object)"vAppStatusToNodeStatus");
    }

    public NodeMetadata apply(VApp from) {
        Object metadataMap;
        NodeMetadataBuilder builder = new NodeMetadataBuilder();
        builder.ids(from.getHref().toASCIIString());
        builder.uri(from.getHref());
        builder.name(from.getName());
        String groupName = "";
        if (!Strings.isNullOrEmpty((String)from.getDescription()) && from.getDescription().indexOf(61) != -1 && from.getDescription().indexOf(10) != -1) {
            try {
                metadataMap = Splitter.on((char)'\n').withKeyValueSeparator("=").split((CharSequence)from.getDescription());
                ComputeServiceUtils.addMetadataAndParseTagsFromCommaDelimitedValue((NodeMetadataBuilder)builder, (Map)metadataMap);
            }
            catch (IllegalArgumentException iae) {
                metadataMap = ImmutableMap.of();
            }
        } else {
            metadataMap = ImmutableMap.of();
        }
        builder.hostname(from.getName());
        builder.location(this.findLocationForResourceInVDC.apply(from.getVDC()));
        builder.group(ComputeServiceUtils.groupFromMapOrName((Map)metadataMap, (String)from.getName(), (GroupNamingConvention)this.nodeNamingConvention));
        builder.operatingSystem(VCloudComputeUtils.toComputeOs(from, null));
        builder.hardware((Hardware)this.hardwareForVApp.apply((Object)from));
        builder.status(this.vAppStatusToNodeStatus.get((Object)from.getStatus()));
        Set<String> addresses = VCloudComputeUtils.getIpsFromVApp(from);
        builder.publicAddresses(Iterables.filter(addresses, (Predicate)Predicates.not((Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE)));
        builder.privateAddresses(Iterables.filter(addresses, (Predicate)InetAddresses2.IsPrivateIPAddress.INSTANCE));
        LoginCredentials fromApi = VCloudComputeUtils.getCredentialsFrom(from);
        if (fromApi != null && !this.credentialStore.containsKey("node#" + from.getHref().toASCIIString())) {
            this.credentialStore.put("node#" + from.getHref().toASCIIString(), (Credentials)fromApi);
        }
        return builder.build();
    }
}

