/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import java.net.URI;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.Memoized;
import org.jclouds.domain.Location;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.ReferenceType;

@Singleton
public class FindLocationForResource
implements Function<ReferenceType, Location> {
    @Resource
    protected Logger logger = Logger.NULL;
    final Supplier<Set<? extends Location>> locations;

    @Inject
    public FindLocationForResource(@Memoized Supplier<Set<? extends Location>> locations) {
        this.locations = locations;
    }

    public Location apply(ReferenceType resource) {
        for (Location input : (Set)this.locations.get()) {
            do {
                if (!URI.create(input.getId()).equals(resource.getHref())) continue;
                return input;
            } while ((input = input.getParent()) != null);
        }
        throw new NoSuchElementException(String.format("resource: %s not found in locations: %s", resource, this.locations.get()));
    }
}

