/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.fallbacks.MapHttp4xxCodesToExceptions;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.vcloud.features.OrgApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.xml.OrgHandler;
import org.jclouds.vcloud.xml.OrgListHandler;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OrgApiTest")
public class OrgApiTest
extends BaseVCloudApiTest<OrgApi> {
    public void testlistOrgs() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(OrgApi.class, (String)"listOrgs", (Class[])new Class[0]);
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of());
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/org HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.orgList+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgListHandler.class);
        this.assertFallbackClassEquals(method, MapHttp4xxCodesToExceptions.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testOrg() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(OrgApi.class, (String)"getOrg", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/org/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/org/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.org+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testFindOrgNamed() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(OrgApi.class, (String)"findOrgNamed", (Class[])new Class[]{String.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)"org"));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/org/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.org+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, OrgHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }
}

