/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.internal;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheLoader;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.ovf.Envelope;
import org.jclouds.ovf.xml.EnvelopeHandlerTest;
import org.jclouds.providers.AnonymousProviderMetadata;
import org.jclouds.providers.ProviderMetadata;
import org.jclouds.rest.AuthorizationException;
import org.jclouds.rest.ConfiguresHttpApi;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.vcloud.VCloudApiMetadata;
import org.jclouds.vcloud.VCloudVersionsApi;
import org.jclouds.vcloud.config.VCloudHttpApiModule;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.CatalogItem;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.VAppTemplate;
import org.jclouds.vcloud.domain.VCloudSession;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.CatalogImpl;
import org.jclouds.vcloud.domain.internal.CatalogItemImpl;
import org.jclouds.vcloud.domain.internal.OrgImpl;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.domain.internal.VDCImpl;
import org.jclouds.vcloud.endpoints.Catalog;
import org.jclouds.vcloud.endpoints.Network;
import org.jclouds.vcloud.endpoints.TasksList;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.internal.VCloudLoginApi;
import org.jclouds.vcloud.xml.VAppTemplateHandlerTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BaseVCloudApiTest")
public abstract class BaseVCloudApiTest<T>
extends BaseAsyncClientTest<T> {
    protected static final ReferenceTypeImpl ORG_REF = new ReferenceTypeImpl("org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/org/1"));
    protected static final ReferenceTypeImpl CATALOG_REF = new ReferenceTypeImpl("catalog", "application/vnd.vmware.vcloud.catalog+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalog/1"));
    protected static final ReferenceTypeImpl TASKSLIST_REF = new ReferenceTypeImpl("tasksList", "application/vnd.vmware.vcloud.tasksList+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/tasksList/1"));
    protected static final ReferenceTypeImpl VDC_REF = new ReferenceTypeImpl("vdc", "application/vnd.vmware.vcloud.vdc+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1"));
    protected static final ReferenceTypeImpl NETWORK_REF = new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.network+xml", URI.create("https://vcloud.safesecureweb.com/network/1990"));
    protected static final Org ORG = new OrgImpl(ORG_REF.getName(), ORG_REF.getType(), ORG_REF.getHref(), "org", null, (Map)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)CATALOG_REF), (Map)ImmutableMap.of((Object)VDC_REF.getName(), (Object)VDC_REF), (Map)ImmutableMap.of((Object)NETWORK_REF.getName(), (Object)NETWORK_REF), (ReferenceType)TASKSLIST_REF, (Iterable)ImmutableList.of());
    protected static final VDC VDC = new VDCImpl(VDC_REF.getName(), VDC_REF.getType(), VDC_REF.getHref(), VDCStatus.READY, null, "description", (Iterable)ImmutableSet.of(), AllocationModel.ALLOCATION_POOL, null, null, null, (Map)ImmutableMap.of((Object)"vapp", (Object)new ReferenceTypeImpl("vapp", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/188849-1")), (Object)"network", (Object)new ReferenceTypeImpl("network", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdcItem/2"))), (Map)ImmutableMap.of((Object)NETWORK_REF.getName(), (Object)NETWORK_REF), 0, 0, 0, false);

    protected void checkFilters(HttpRequest request) {
        Assert.assertEquals((int)request.getFilters().size(), (int)1);
        Assert.assertEquals(((HttpRequestFilter)request.getFilters().get(0)).getClass(), AddVCloudAuthorizationAndCookieToRequest.class);
    }

    protected Module createModule() {
        return new VCloudHttpApiModuleExtension();
    }

    protected ProviderMetadata createProviderMetadata() {
        return AnonymousProviderMetadata.forApiWithEndpoint((ApiMetadata)new VCloudApiMetadata(), (String)"https://vcenterprise.bluelock.com/api/v1.0");
    }

    @ConfiguresHttpApi
    public static class VCloudHttpApiModuleExtension
    extends VCloudHttpApiModule {
        protected Supplier<URI> provideAuthenticationURI(VCloudVersionsApi versionService, String version) {
            return Suppliers.ofInstance((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/login"));
        }

        protected Supplier<Org> provideOrg(Supplier<Map<String, Org>> orgSupplier, @org.jclouds.vcloud.endpoints.Org Supplier<ReferenceType> defaultOrg) {
            return Suppliers.ofInstance((Object)ORG);
        }

        protected void installDefaultVCloudEndpointsModule() {
            this.install((Module)new AbstractModule(){

                protected void configure() {
                    TypeLiteral<Supplier<ReferenceType>> refTypeSupplier = new TypeLiteral<Supplier<ReferenceType>>(){};
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.vcloud.endpoints.Org.class).toInstance((Object)Suppliers.ofInstance((Object)ORG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Catalog.class).toInstance((Object)Suppliers.ofInstance((Object)CATALOG_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(TasksList.class).toInstance((Object)Suppliers.ofInstance((Object)TASKSLIST_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(org.jclouds.vcloud.endpoints.VDC.class).toInstance((Object)Suppliers.ofInstance((Object)VDC_REF));
                    this.bind((TypeLiteral)refTypeSupplier).annotatedWith(Network.class).toInstance((Object)Suppliers.ofInstance((Object)NETWORK_REF));
                }
            });
        }

        protected Supplier<VCloudSession> provideVCloudTokenCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, VCloudLoginApi login) {
            return Suppliers.ofInstance((Object)new VCloudSession(){

                public Map<String, ReferenceType> getOrgs() {
                    return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ORG_REF);
                }

                public String getVCloudToken() {
                    return "token";
                }
            });
        }

        protected void configure() {
            super.configure();
            this.bind(VCloudHttpApiModule.OrgMapSupplier.class).to(TestOrgMapSupplier.class);
            this.bind(VCloudHttpApiModule.OrgCatalogSupplier.class).to(TestOrgCatalogSupplier.class);
            this.bind(VCloudHttpApiModule.OrgCatalogItemSupplier.class).to(TestOrgCatalogItemSupplier.class);
        }

        protected void bindCacheLoaders() {
            this.bind((TypeLiteral)new TypeLiteral<CacheLoader<URI, VAppTemplate>>(){}).toInstance(CacheLoader.class.cast(CacheLoader.from((Function)Functions.constant((Object)VAppTemplateHandlerTest.parseTemplate()))));
            this.bind((TypeLiteral)new TypeLiteral<CacheLoader<URI, Envelope>>(){}).toInstance(CacheLoader.class.cast(CacheLoader.from((Function)Functions.constant((Object)EnvelopeHandlerTest.parseEnvelope()))));
        }

        protected Supplier<Map<String, Map<String, VDC>>> provideOrgVDCSupplierCache(@Named(value="jclouds.session-interval") long seconds, AtomicReference<AuthorizationException> authException, VCloudHttpApiModule.OrgVDCSupplier supplier) {
            return Suppliers.ofInstance((Object)ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)VDC.getName(), (Object)VDC)));
        }

        @Singleton
        public static class TestOrgCatalogItemSupplier
        extends VCloudHttpApiModule.OrgCatalogItemSupplier {
            protected TestOrgCatalogItemSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, Map<String, CatalogItem>>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)ImmutableMap.of((Object)"template", (Object)new CatalogItemImpl("template", URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalogItem/2"), "description", (ReferenceType)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/vAppTemplate/2")), (Map)ImmutableMap.of()))));
            }
        }

        @Singleton
        public static class TestOrgCatalogSupplier
        extends VCloudHttpApiModule.OrgCatalogSupplier {
            @Inject
            protected TestOrgCatalogSupplier() {
                super(null, null);
            }

            public Map<String, Map<String, org.jclouds.vcloud.domain.Catalog>> get() {
                return ImmutableMap.of((Object)ORG_REF.getName(), (Object)ImmutableMap.of((Object)CATALOG_REF.getName(), (Object)new CatalogImpl(CATALOG_REF.getName(), CATALOG_REF.getType(), CATALOG_REF.getHref(), null, "description", (Map)ImmutableMap.of((Object)"item", (Object)new ReferenceTypeImpl("item", "application/vnd.vmware.vcloud.catalogItem+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalogItem/1")), (Object)"template", (Object)new ReferenceTypeImpl("template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/catalogItem/2"))), (Iterable)ImmutableList.of(), true, false)));
            }
        }

        @Singleton
        public static class TestOrgMapSupplier
        extends VCloudHttpApiModule.OrgMapSupplier {
            @Inject
            protected TestOrgMapSupplier() {
                super(null, null);
            }

            public Map<String, Org> get() {
                return ImmutableMap.of((Object)ORG.getName(), (Object)ORG);
            }
        }
    }
}

