/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.OrgListHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="OrgListHandlerTest")
public class OrgListHandlerTest
extends BaseHandlerTest {
    public void testApplyInputStream() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/orglist.xml");
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(OrgListHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)ImmutableMap.of((Object)"adrian@jclouds.org", (Object)new ReferenceTypeImpl("adrian@jclouds.org", "application/vnd.vmware.vcloud.org+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/org/48"))));
    }

    public void testSavvis() {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/orglist-savvis.xml");
        Map result = (Map)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(OrgListHandler.class)).parse(is);
        Assert.assertEquals((Map)result, (Map)ImmutableMap.of((Object)"SAVVISStation Integration Testing", (Object)new ReferenceTypeImpl("SAVVISStation Integration Testing", "application/vnd.vmware.vcloud.org+xml", URI.create("https://api.sandbox.symphonyvpdc.savvis.net/rest/api/v0.8/org/100000.0"))));
    }
}

