/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.suppliers;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.annotation.Resource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.jclouds.concurrent.FutureIterables;
import org.jclouds.logging.Logger;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.VAppTemplate;

@Singleton
public class VAppTemplatesSupplier
implements Supplier<Set<VAppTemplate>> {
    @Resource
    @Named(value="jclouds.compute")
    public Logger logger = Logger.NULL;
    private final Supplier<Map<String, Org>> orgMap;
    private final Function<Org, Iterable<VAppTemplate>> imagesInOrg;
    private final ListeningExecutorService userExecutor;

    @Inject
    VAppTemplatesSupplier(Supplier<Map<String, Org>> orgMap, Function<Org, Iterable<VAppTemplate>> imagesInOrg, @Named(value="jclouds.user-threads") ListeningExecutorService userExecutor) {
        this.orgMap = (Supplier)Preconditions.checkNotNull(orgMap, (Object)"orgMap");
        this.imagesInOrg = (Function)Preconditions.checkNotNull(imagesInOrg, (Object)"imagesInOrg");
        this.userExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)userExecutor, (Object)"userExecutor");
    }

    public Set<VAppTemplate> get() {
        Iterable orgs = (Iterable)Preconditions.checkNotNull(((Map)this.orgMap.get()).values(), (Object)"orgs");
        Iterable images = FutureIterables.transformParallel((Iterable)orgs, (Function)new Function<Org, ListenableFuture<? extends Iterable<VAppTemplate>>>(){

            public ListenableFuture<Iterable<VAppTemplate>> apply(final Org from) {
                Preconditions.checkNotNull((Object)from, (Object)"org");
                return VAppTemplatesSupplier.this.userExecutor.submit((Callable)new Callable<Iterable<VAppTemplate>>(){

                    @Override
                    public Iterable<VAppTemplate> call() throws Exception {
                        return (Iterable)VAppTemplatesSupplier.this.imagesInOrg.apply((Object)from);
                    }

                    public String toString() {
                        return "imagesInOrg(" + from.getHref() + ")";
                    }
                });
            }
        }, (ListeningExecutorService)this.userExecutor, null, (Logger)this.logger, (String)("images in " + orgs));
        return Sets.newLinkedHashSet((Iterable)Iterables.concat((Iterable)images));
    }
}

