/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.Capacity;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.Task;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;

public class VDCImpl
extends ReferenceTypeImpl
implements VDC {
    private final VDCStatus status;
    private final ReferenceType org;
    @Nullable
    private final String description;
    private final List<Task> tasks = Lists.newArrayList();
    private final AllocationModel allocationModel;
    private final Capacity storageCapacity;
    private final Capacity cpuCapacity;
    private final Capacity memoryCapacity;
    private final Map<String, ReferenceType> resourceEntities = Maps.newLinkedHashMap();
    private final Map<String, ReferenceType> availableNetworks = Maps.newLinkedHashMap();
    private final int nicQuota;
    private final int networkQuota;
    private final int vmQuota;
    private final boolean isEnabled;

    public VDCImpl(String name, String type, URI id, VDCStatus status, ReferenceType org, @Nullable String description, Iterable<Task> tasks, AllocationModel allocationModel, @Nullable Capacity storageCapacity, @Nullable Capacity cpuCapacity, @Nullable Capacity memoryCapacity, Map<String, ReferenceType> resourceEntities, Map<String, ReferenceType> availableNetworks, int nicQuota, int networkQuota, int vmQuota, boolean isEnabled) {
        super(name, type, id);
        this.status = (VDCStatus)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status"));
        this.org = org;
        this.description = description;
        Iterables.addAll(this.tasks, (Iterable)((Iterable)Preconditions.checkNotNull(tasks, (Object)"tasks")));
        this.allocationModel = (AllocationModel)((Object)Preconditions.checkNotNull((Object)((Object)allocationModel), (Object)"allocationModel"));
        this.storageCapacity = storageCapacity;
        this.cpuCapacity = cpuCapacity;
        this.memoryCapacity = memoryCapacity;
        this.resourceEntities.putAll((Map)Preconditions.checkNotNull(resourceEntities, (Object)"resourceEntities"));
        this.availableNetworks.putAll((Map)Preconditions.checkNotNull(availableNetworks, (Object)"availableNetworks"));
        this.nicQuota = nicQuota;
        this.networkQuota = networkQuota;
        this.vmQuota = vmQuota;
        this.isEnabled = isEnabled;
    }

    @Override
    public VDCStatus getStatus() {
        return this.status;
    }

    @Override
    public ReferenceType getOrg() {
        return this.org;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<Task> getTasks() {
        return this.tasks;
    }

    @Override
    public AllocationModel getAllocationModel() {
        return this.allocationModel;
    }

    @Override
    public Capacity getStorageCapacity() {
        return this.storageCapacity;
    }

    @Override
    public Capacity getCpuCapacity() {
        return this.cpuCapacity;
    }

    @Override
    public Capacity getMemoryCapacity() {
        return this.memoryCapacity;
    }

    @Override
    public Map<String, ReferenceType> getResourceEntities() {
        return this.resourceEntities;
    }

    @Override
    public Map<String, ReferenceType> getAvailableNetworks() {
        return this.availableNetworks;
    }

    @Override
    public int getNicQuota() {
        return this.nicQuota;
    }

    @Override
    public int getNetworkQuota() {
        return this.networkQuota;
    }

    @Override
    public int getVmQuota() {
        return this.vmQuota;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.allocationModel == null ? 0 : this.allocationModel.hashCode());
        result = 31 * result + (this.availableNetworks == null ? 0 : this.availableNetworks.hashCode());
        result = 31 * result + (this.cpuCapacity == null ? 0 : this.cpuCapacity.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.isEnabled ? 1231 : 1237);
        result = 31 * result + (this.memoryCapacity == null ? 0 : this.memoryCapacity.hashCode());
        result = 31 * result + this.networkQuota;
        result = 31 * result + this.nicQuota;
        result = 31 * result + (this.org == null ? 0 : this.org.hashCode());
        result = 31 * result + (this.resourceEntities == null ? 0 : this.resourceEntities.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.storageCapacity == null ? 0 : this.storageCapacity.hashCode());
        result = 31 * result + (this.tasks == null ? 0 : this.tasks.hashCode());
        result = 31 * result + this.vmQuota;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VDCImpl other = (VDCImpl)obj;
        if (this.allocationModel == null ? other.allocationModel != null : !this.allocationModel.equals((Object)other.allocationModel)) {
            return false;
        }
        if (this.availableNetworks == null ? other.availableNetworks != null : !this.availableNetworks.equals(other.availableNetworks)) {
            return false;
        }
        if (this.cpuCapacity == null ? other.cpuCapacity != null : !this.cpuCapacity.equals(other.cpuCapacity)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.isEnabled != other.isEnabled) {
            return false;
        }
        if (this.memoryCapacity == null ? other.memoryCapacity != null : !this.memoryCapacity.equals(other.memoryCapacity)) {
            return false;
        }
        if (this.networkQuota != other.networkQuota) {
            return false;
        }
        if (this.nicQuota != other.nicQuota) {
            return false;
        }
        if (this.org == null ? other.org != null : !this.org.equals(other.org)) {
            return false;
        }
        if (this.resourceEntities == null ? other.resourceEntities != null : !this.resourceEntities.equals(other.resourceEntities)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.storageCapacity == null ? other.storageCapacity != null : !this.storageCapacity.equals(other.storageCapacity)) {
            return false;
        }
        if (this.tasks == null ? other.tasks != null : !this.tasks.equals(other.tasks)) {
            return false;
        }
        return this.vmQuota == other.vmQuota;
    }

    @Override
    public String toString() {
        return "[id=" + this.getHref() + ", name=" + this.getName() + ", org=" + this.org + ", description=" + this.description + ", status=" + (Object)((Object)this.status) + ", isEnabled=" + this.isEnabled + "]";
    }
}

