/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.Invokable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import org.jclouds.Fallbacks;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.ReleasePayloadAndReturn;
import org.jclouds.http.functions.ReturnInputStream;
import org.jclouds.reflect.Reflection2;
import org.jclouds.rest.internal.GeneratedHttpRequest;
import org.jclouds.util.Strings2;
import org.jclouds.vcloud.domain.GuestCustomizationSection;
import org.jclouds.vcloud.features.VmApi;
import org.jclouds.vcloud.internal.BaseVCloudApiTest;
import org.jclouds.vcloud.utils.TestUtils;
import org.jclouds.vcloud.xml.TaskHandler;
import org.jclouds.vcloud.xml.VmHandler;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="VmApiTest")
public class VmApiTest
extends BaseVCloudApiTest<VmApi> {
    public void testGetThumbnailOfVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"getScreenThumbnailForVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("http://vcloud.example.com/api/v1.0/vApp/vm-12")));
        this.assertRequestLineEquals((HttpRequest)request, "GET http://vcloud.example.com/api/v1.0/vApp/vm-12/screen HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: image/png\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReturnInputStream.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    @Test(dataProvider="ignoreOnWindows", description="see http://code.google.com/p/jclouds/issues/detail?id=402")
    public void testUpdateGuestConfiguration() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"updateGuestCustomizationOfVm", (Class[])new Class[]{GuestCustomizationSection.class, URI.class});
        GuestCustomizationSection guest = new GuestCustomizationSection(URI.create("http://vcloud.example.com/api/v1.0/vApp/vm-12/guestCustomizationSection"));
        guest.setCustomizationScript("cat > /tmp/foo.txt<<EOF\nI love candy\nEOF");
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)guest, (Object)URI.create("http://vcloud.example.com/api/v1.0/vApp/vm-12")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://vcloud.example.com/api/v1.0/vApp/vm-12/guestCustomizationSection HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/guestCustomizationSection.xml")), "application/vnd.vmware.vcloud.guestCustomizationSection+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUpdateCPUCountOfVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"updateCPUCountOfVm", (Class[])new Class[]{Integer.TYPE, URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)2, (Object)URI.create("http://vcloud.example.com/api/v1.0/vApp/vm-12")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://vcloud.example.com/api/v1.0/vApp/vm-12/virtualHardwareSection/cpu HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/cpuItem.xml")), "application/vnd.vmware.vcloud.rasdItem+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUpdateMemoryMBOfVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"updateMemoryMBOfVm", (Class[])new Class[]{Integer.TYPE, URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)512, (Object)URI.create("http://vcloud.example.com/api/v1.0/vApp/vm-12")));
        this.assertRequestLineEquals((HttpRequest)request, "PUT http://vcloud.example.com/api/v1.0/vApp/vm-12/virtualHardwareSection/memory HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, Strings2.toStringAndClose((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("/memoryItem.xml")), "application/vnd.vmware.vcloud.rasdItem+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeployVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"deployVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/deploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<DeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\"/>", "application/vnd.vmware.vcloud.deployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testDeployAndPowerOnVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"deployAndPowerOnVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/deploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<DeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\" powerOn=\"true\"/>", "application/vnd.vmware.vcloud.deployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testGetVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"getVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vm/1")));
        this.assertRequestLineEquals((HttpRequest)request, "GET https://vcenterprise.bluelock.com/api/v1.0/vm/1 HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.vm+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, VmHandler.class);
        this.assertFallbackClassEquals(method, Fallbacks.NullOnNotFoundOr404.class);
        this.checkFilters((HttpRequest)request);
    }

    public void testRebootVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"rebootVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/reboot HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUndeployVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"undeployVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/undeploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\"/>", "application/vnd.vmware.vcloud.undeployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testUndeployAndSaveStateOfVmSaveState() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"undeployAndSaveStateOfVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/action/undeploy HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, "<UndeployVAppParams xmlns=\"http://www.vmware.com/vcloud/v1\" saveState=\"true\"/>", "application/vnd.vmware.vcloud.undeployVAppParams+xml", false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOnVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"powerOnVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/powerOn HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testPowerOffVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"powerOffVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/powerOff HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testResetVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"resetVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/reset HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testSuspendVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"suspendVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/suspend HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "Accept: application/vnd.vmware.vcloud.task+xml\n");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ParseSax.class);
        this.assertSaxResponseParserClassEquals(method, TaskHandler.class);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    public void testShutdownVm() throws SecurityException, NoSuchMethodException, IOException {
        Invokable method = Reflection2.method(VmApi.class, (String)"shutdownVm", (Class[])new Class[]{URI.class});
        GeneratedHttpRequest request = this.processor.createRequest(method, (List)ImmutableList.of((Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vApp/1")));
        this.assertRequestLineEquals((HttpRequest)request, "POST https://vcenterprise.bluelock.com/api/v1.0/vApp/1/power/action/shutdown HTTP/1.1");
        this.assertNonPayloadHeadersEqual((HttpRequest)request, "");
        this.assertPayloadEquals((HttpRequest)request, null, null, false);
        this.assertResponseParserClassEquals(method, request, ReleasePayloadAndReturn.class);
        this.assertSaxResponseParserClassEquals(method, null);
        this.assertFallbackClassEquals(method, null);
        this.checkFilters((HttpRequest)request);
    }

    @DataProvider
    public Object[][] ignoreOnWindows() {
        return TestUtils.isWindowsOs() ? TestUtils.NO_INVOCATIONS : TestUtils.SINGLE_NO_ARG_INVOCATION;
    }
}

