/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.inject.Key;
import org.jclouds.compute.ComputeServiceContext;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.internal.BaseVCloudApiLiveTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"live"}, enabled=true, singleThreaded=true, testName="CatalogApiLiveTest")
public class CatalogApiLiveTest
extends BaseVCloudApiLiveTest {
    @Test
    public void testGetCatalog() throws Exception {
        Org org = this.getVCloudApi().getOrgApi().findOrgNamed(null);
        for (ReferenceType catalog : org.getCatalogs().values()) {
            Assert.assertEquals((String)catalog.getType(), (String)"application/vnd.vmware.vcloud.catalog+xml");
            Assert.assertNotNull((Object)this.getVCloudApi().getCatalogApi().getCatalog(catalog.getHref()));
        }
    }

    @Test
    public void testFindCatalogIsWriteableIfNotVersion1_5() throws Exception {
        if (!((String)((ComputeServiceContext)this.view).utils().injector().getInstance(Key.get(String.class, ApiVersion.class))).startsWith("1.5")) {
            Assert.assertTrue((boolean)this.getVCloudApi().getCatalogApi().findCatalogInOrgNamed(null, null).isReadOnly());
        }
    }
}

