/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.compute.functions;

import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.NoSuchElementException;
import org.jclouds.domain.Location;
import org.jclouds.domain.LocationBuilder;
import org.jclouds.domain.LocationScope;
import org.jclouds.vcloud.compute.functions.FindLocationForResource;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class FindLocationForResourceTest {
    public void testMatchWhenIdIsHref() {
        Location location = new LocationBuilder().id("http://foo").description("description").scope(LocationScope.PROVIDER).build();
        FindLocationForResource converter = new FindLocationForResource(Suppliers.ofInstance((Object)ImmutableSet.of((Object)location)));
        Assert.assertEquals((Object)converter.apply((ReferenceType)new ReferenceTypeImpl("name", "type", URI.create("http://foo"))), (Object)location);
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testGracefulWhenHrefIsntLocationId() {
        FindLocationForResource converter = new FindLocationForResource(Suppliers.ofInstance((Object)ImmutableSet.of((Object)new LocationBuilder().id("http://bar").description("description").scope(LocationScope.PROVIDER).build())));
        converter.apply((ReferenceType)new ReferenceTypeImpl("name", "type", URI.create("http://foo")));
    }

    @Test(expectedExceptions={NoSuchElementException.class})
    public void testGracefulWhenLocationIdIsntURI() {
        FindLocationForResource converter = new FindLocationForResource(Suppliers.ofInstance((Object)ImmutableSet.of((Object)new LocationBuilder().id("1").description("description").scope(LocationScope.PROVIDER).build())));
        converter.apply((ReferenceType)new ReferenceTypeImpl("name", "type", URI.create("http://foo")));
    }
}

