/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain.network.nat.rules;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.jclouds.vcloud.domain.network.nat.NatProtocol;
import org.jclouds.vcloud.domain.network.nat.NatRule;

public class PortForwardingRule
implements NatRule {
    private final String externalIP;
    private final int externalPort;
    private final String internalIP;
    private final int internalPort;
    private final NatProtocol protocol;

    public PortForwardingRule(String externalIP, int externalPort, String internalIP, int internalPort, NatProtocol protocol) {
        this.externalIP = (String)Preconditions.checkNotNull((Object)externalIP, (Object)"externalIP");
        this.externalPort = externalPort;
        this.internalIP = (String)Preconditions.checkNotNull((Object)internalIP, (Object)"internalIP");
        this.internalPort = internalPort;
        this.protocol = (NatProtocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol"));
    }

    @Override
    public String getExternalIP() {
        return this.externalIP;
    }

    public int getExternalPort() {
        return this.externalPort;
    }

    public String getInternalIP() {
        return this.internalIP;
    }

    public int getInternalPort() {
        return this.internalPort;
    }

    public NatProtocol getProtocol() {
        return this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PortForwardingRule that = (PortForwardingRule)PortForwardingRule.class.cast(o);
        return Objects.equal((Object)this.externalIP, (Object)that.externalIP) && Objects.equal((Object)this.externalPort, (Object)that.externalPort) && Objects.equal((Object)this.internalIP, (Object)that.internalIP) && Objects.equal((Object)this.internalPort, (Object)that.internalPort) && Objects.equal((Object)((Object)this.protocol), (Object)((Object)that.protocol));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.externalIP, this.externalPort, this.internalIP, this.internalPort, this.protocol});
    }

    public String toString() {
        return Objects.toStringHelper((String)"").omitNullValues().add("externalIP", (Object)this.externalIP).add("externalPort", this.externalPort).add("internalIP", (Object)this.internalIP).add("internalPort", this.internalPort).add("protocol", (Object)this.protocol).toString();
    }
}

