/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.domain;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;

public enum AllocationModel {
    ALLOCATION_VAPP,
    ALLOCATION_POOL,
    RESERVATION_POOL,
    UNRECOGNIZED;


    public String value() {
        switch (this) {
            case ALLOCATION_VAPP: {
                return "AllocationVApp";
            }
            case ALLOCATION_POOL: {
                return "AllocationPool";
            }
            case RESERVATION_POOL: {
                return "ReservationPool";
            }
        }
        return "UnrecognizedModel";
    }

    public String toString() {
        return this.value();
    }

    public static AllocationModel fromValue(String model) {
        try {
            return AllocationModel.valueOf(CaseFormat.UPPER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, (String)Preconditions.checkNotNull((Object)model, (Object)"model")));
        }
        catch (IllegalArgumentException e) {
            return UNRECOGNIZED;
        }
    }
}

