/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import java.io.InputStream;
import java.net.UnknownHostException;
import org.jclouds.http.functions.BaseHandlerTest;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;
import org.jclouds.vcloud.xml.NetworkConnectionHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="NetworkConnectionHandlerTest")
public class NetworkConnectionHandlerTest
extends BaseHandlerTest {
    public void testDefault() throws UnknownHostException {
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/networkconnection.xml");
        NetworkConnection result = (NetworkConnection)this.factory.create((ParseSax.HandlerWithResult)this.injector.getInstance(NetworkConnectionHandler.class)).parse(is);
        NetworkConnectionHandlerTest.checkNetworkConnection(result);
    }

    @Test(enabled=false)
    public static void checkNetworkConnection(NetworkConnection result) {
        Assert.assertEquals((String)result.getNetwork(), (String)"internet01");
        Assert.assertEquals((int)result.getNetworkConnectionIndex(), (int)0);
        Assert.assertEquals((String)result.getIpAddress(), (String)"174.47.101.164");
        Assert.assertEquals((String)result.getExternalIpAddress(), null);
        Assert.assertEquals((boolean)result.isConnected(), (boolean)true);
        Assert.assertEquals((String)result.getMACAddress(), (String)"00:50:56:01:01:f2");
        Assert.assertEquals((Object)result.getIpAddressAllocationMode(), (Object)IpAddressAllocationMode.POOL);
    }
}

