/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.features;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.URI;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.rest.annotations.Endpoint;
import org.jclouds.rest.annotations.EndpointParam;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.XMLResponseParser;
import org.jclouds.vcloud.domain.Org;
import org.jclouds.vcloud.domain.ReferenceType;
import org.jclouds.vcloud.endpoints.OrgList;
import org.jclouds.vcloud.filters.AddVCloudAuthorizationAndCookieToRequest;
import org.jclouds.vcloud.functions.OrgNameToEndpoint;
import org.jclouds.vcloud.xml.OrgHandler;
import org.jclouds.vcloud.xml.OrgListHandler;

@RequestFilters(value={AddVCloudAuthorizationAndCookieToRequest.class})
public interface OrgAsyncClient {
    @GET
    @Endpoint(value=OrgList.class)
    @XMLResponseParser(value=OrgListHandler.class)
    @Consumes(value={"application/vnd.vmware.vcloud.orgList+xml"})
    public ListenableFuture<Map<String, ReferenceType>> listOrgs();

    @GET
    @XMLResponseParser(value=OrgHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.org+xml"})
    public ListenableFuture<Org> getOrg(@EndpointParam URI var1);

    @GET
    @XMLResponseParser(value=OrgHandler.class)
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Consumes(value={"application/vnd.vmware.vcloud.org+xml"})
    public ListenableFuture<Org> findOrgNamed(@Nullable @EndpointParam(parser=OrgNameToEndpoint.class) String var1);
}

