/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.xml;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.jclouds.http.functions.ParseSax;
import org.jclouds.http.functions.config.SaxParserModule;
import org.jclouds.vcloud.domain.AllocationModel;
import org.jclouds.vcloud.domain.Capacity;
import org.jclouds.vcloud.domain.VDC;
import org.jclouds.vcloud.domain.VDCStatus;
import org.jclouds.vcloud.domain.internal.ReferenceTypeImpl;
import org.jclouds.vcloud.xml.VDCHandler;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class VDCHandlerTest {
    public void testVCloud1_0() {
        InputStream is = this.getClass().getResourceAsStream("/vdc-1.0.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VDC result = (VDC)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VDCHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Jclouds-Commit-compG1xstorA01");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcenterprise.bluelock.com/api/v1.0/vdc/1014839439"));
        Assert.assertEquals((String)result.getType(), (String)"application/vnd.vmware.vcloud.vdc+xml");
        Assert.assertEquals((Object)result.getStatus(), (Object)VDCStatus.READY);
        Assert.assertEquals((Object)result.getOrg(), (Object)new ReferenceTypeImpl(null, "application/vnd.vmware.vcloud.org+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/org/9566014")));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Collection)result.getTasks(), (Collection)ImmutableList.of());
        Assert.assertEquals((Object)result.getAllocationModel(), (Object)AllocationModel.ALLOCATION_POOL);
        Assert.assertEquals((Object)result.getStorageCapacity(), (Object)new Capacity("MB", 1024000L, 1024000L, 0, 0L));
        Assert.assertEquals((Object)result.getCpuCapacity(), (Object)new Capacity("MHz", 20000L, 20000L, 0, 0L));
        Assert.assertEquals((Object)result.getMemoryCapacity(), (Object)new Capacity("MB", 30720L, 30720L, 0, 0L));
        Assert.assertEquals((Map)result.getResourceEntities(), (Map)ImmutableMap.of());
        Assert.assertEquals((Map)result.getAvailableNetworks(), (Map)ImmutableMap.of((Object)"isolation01", (Object)new ReferenceTypeImpl("isolation01", "application/vnd.vmware.vcloud.network+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/990419644")), (Object)"internet01", (Object)new ReferenceTypeImpl("internet01", "application/vnd.vmware.vcloud.network+xml", URI.create("https://vcenterprise.bluelock.com/api/v1.0/network/758634723"))));
        Assert.assertEquals((int)result.getNicQuota(), (int)0);
        Assert.assertEquals((int)result.getNetworkQuota(), (int)100);
        Assert.assertEquals((int)result.getVmQuota(), (int)50);
        assert (result.isEnabled());
    }

    public void testTerremark() {
        InputStream is = this.getClass().getResourceAsStream("/vdc.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VDC result = (VDC)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VDCHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"Miami Environment 1");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vdc/32"));
        Assert.assertEquals((String)result.getDescription(), null);
        Assert.assertEquals((Object)result.getStorageCapacity(), (Object)new Capacity("bytes * 10^9", 100L, 0L, 8, 0L));
        Assert.assertEquals((Object)result.getCpuCapacity(), (Object)new Capacity("hz * 10^6", 5000L, 0L, 0, 0L));
        Assert.assertEquals((Object)result.getMemoryCapacity(), (Object)new Capacity("bytes * 2^20", 10240L, 0L, 0, 0L));
        Assert.assertEquals((int)result.getVmQuota(), (int)0);
        Assert.assertEquals((Map)result.getResourceEntities(), (Map)ImmutableMap.of((Object)"adriantest", (Object)new ReferenceTypeImpl("adriantest", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15124")), (Object)"centos-53", (Object)new ReferenceTypeImpl("centos-53", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/vapp/15120"))));
        Assert.assertEquals((Map)result.getAvailableNetworks(), (Map)ImmutableMap.of((Object)"10.114.34.128/26", (Object)new ReferenceTypeImpl("10.114.34.128/26", "application/vnd.vmware.vcloud.network+xml", URI.create("https://services.vcloudexpress.terremark.com/api/v0.8/network/1708"))));
    }

    public void testHostingDotCom() {
        InputStream is = this.getClass().getResourceAsStream("/vdc-hosting.xml");
        Injector injector = Guice.createInjector((Module[])new Module[]{new SaxParserModule()});
        ParseSax.Factory factory = (ParseSax.Factory)injector.getInstance(ParseSax.Factory.class);
        VDC result = (VDC)factory.create((ParseSax.HandlerWithResult)injector.getInstance(VDCHandler.class)).parse(is);
        Assert.assertEquals((String)result.getName(), (String)"vDC Name");
        Assert.assertEquals((Object)result.getHref(), (Object)URI.create("https://vcloud.safesecureweb.com/api/v0.8/vdc/188849"));
        Assert.assertEquals((String)result.getDescription(), (String)"vDC Name");
        Assert.assertEquals((Object)result.getStorageCapacity(), (Object)new Capacity("bytes * 10^9", 0L, 0L, 40960, 0L));
        Assert.assertEquals((Object)result.getCpuCapacity(), (Object)new Capacity("hz * 10^6", 0L, 0L, 2400, 0L));
        Assert.assertEquals((Object)result.getMemoryCapacity(), (Object)new Capacity("bytes * 10^9", 0L, 0L, 2, 0L));
        Assert.assertEquals((int)result.getVmQuota(), (int)0);
        Assert.assertEquals((Map)result.getResourceEntities(), (Map)new ImmutableMap.Builder().put((Object)"Plesk (Linux) 64-bit Template", (Object)new ReferenceTypeImpl("Plesk (Linux) 64-bit Template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/1"))).put((Object)"Windows 2008 Datacenter 64 Bit Template", (Object)new ReferenceTypeImpl("Windows 2008 Datacenter 64 Bit Template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/2"))).put((Object)"Cent OS 64 Bit Template", (Object)new ReferenceTypeImpl("Cent OS 64 Bit Template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/3"))).put((Object)"cPanel (Linux) 64 Bit Template", (Object)new ReferenceTypeImpl("cPanel (Linux) 64 Bit Template", "application/vnd.vmware.vcloud.vAppTemplate+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vAppTemplate/4"))).put((Object)"188849-1", (Object)new ReferenceTypeImpl("188849-1", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-1"))).put((Object)"188849-2", (Object)new ReferenceTypeImpl("188849-2", "application/vnd.vmware.vcloud.vApp+xml", URI.create("https://vcloud.safesecureweb.com/api/v0.8/vApp/188849-2"))).build());
        Assert.assertEquals((Map)result.getAvailableNetworks(), (Map)ImmutableMap.of());
    }
}

