/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.vcloud.binders;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import org.jclouds.http.HttpRequest;
import org.jclouds.vcloud.binders.BindNetworkConnectionSectionToXmlPayload;
import org.jclouds.vcloud.domain.NetworkConnection;
import org.jclouds.vcloud.domain.NetworkConnectionSection;
import org.jclouds.vcloud.domain.network.IpAddressAllocationMode;
import org.jclouds.vcloud.internal.BasePayloadTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="BindNetworkConnectionSectionToXmlPayloadTest")
public class BindNetworkConnectionSectionToXmlPayloadTest
extends BasePayloadTest {
    public void testWithIpAllocationModeNONE() throws IOException {
        HttpRequest request = HttpRequest.builder().endpoint("http://localhost/key").method("GET").build();
        BindNetworkConnectionSectionToXmlPayload binder = (BindNetworkConnectionSectionToXmlPayload)this.injector.getInstance(BindNetworkConnectionSectionToXmlPayload.class);
        binder.bindToRequest(request, (Object)NetworkConnectionSection.builder().type("application/vnd.vmware.vcloud.networkConnectionSection+xml").info("Specifies the available VM network connections").href(URI.create("https://1.1.1.1/api/v1.0/vApp/vm-1/networkConnectionSection/")).connections((Iterable)ImmutableSet.of((Object)NetworkConnection.builder().network("none").ipAddressAllocationMode(IpAddressAllocationMode.NONE).build())).build());
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"application/vnd.vmware.vcloud.networkConnectionSection+xml");
        Assert.assertEquals((Object)request.getPayload().getRawContent(), (Object)"<NetworkConnectionSection xmlns=\"http://www.vmware.com/vcloud/v1\" xmlns:ovf=\"http://schemas.dmtf.org/ovf/envelope/1\" href=\"https://1.1.1.1/api/v1.0/vApp/vm-1/networkConnectionSection/\" ovf:required=\"false\" type=\"application/vnd.vmware.vcloud.networkConnectionSection+xml\"><ovf:Info>Specifies the available VM network connections</ovf:Info><NetworkConnection network=\"none\"><NetworkConnectionIndex>0</NetworkConnectionIndex><IsConnected>false</IsConnected><IpAddressAllocationMode>NONE</IpAddressAllocationMode></NetworkConnection></NetworkConnectionSection>");
    }
}

