/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.VaultMetadata;
import org.jclouds.glacier.options.PaginationOptions;

public class PaginatedVaultCollection
extends IterableWithMarker<VaultMetadata> {
    @SerializedName(value="VaultList")
    private final Iterable<VaultMetadata> vaults;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"VaultList", "Marker"})
    public PaginatedVaultCollection(Iterable<VaultMetadata> vaults, String marker) {
        this.vaults = (Iterable)Preconditions.checkNotNull(vaults, (Object)"vaults");
        this.marker = marker;
    }

    public Iterator<VaultMetadata> iterator() {
        return this.vaults.iterator();
    }

    public Optional<Object> nextMarker() {
        return Optional.fromNullable((Object)this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)((Object)PaginationOptions.class.cast(this.nextMarker().get()));
    }
}

