/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.glacier.domain;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.gson.annotations.SerializedName;
import java.beans.ConstructorProperties;
import java.util.Iterator;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.glacier.domain.MultipartUploadMetadata;
import org.jclouds.glacier.options.PaginationOptions;
import org.jclouds.javax.annotation.Nullable;

public class PaginatedMultipartUploadCollection
extends IterableWithMarker<MultipartUploadMetadata> {
    @SerializedName(value="UploadsList")
    private final Iterable<MultipartUploadMetadata> uploads;
    @SerializedName(value="Marker")
    private final String marker;

    @ConstructorProperties(value={"UploadsList", "Marker"})
    public PaginatedMultipartUploadCollection(Iterable<MultipartUploadMetadata> uploads, @Nullable String marker) {
        this.uploads = (Iterable)Preconditions.checkNotNull(uploads, (Object)"uploads");
        this.marker = marker;
    }

    public Iterator<MultipartUploadMetadata> iterator() {
        return this.uploads.iterator();
    }

    public Optional<Object> nextMarker() {
        return Optional.fromNullable((Object)this.marker);
    }

    public PaginationOptions nextPaginationOptions() {
        return (PaginationOptions)((Object)PaginationOptions.class.cast(this.nextMarker().get()));
    }
}

