/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.cli.mailbox;

import java.util.concurrent.Callable;
import org.apache.james.cli.mailbox.MailboxCommand;
import org.apache.james.webadmin.httpclient.MailboxClient;
import org.apache.james.webadmin.httpclient.feign.JamesFeignException;
import picocli.CommandLine;

@CommandLine.Command(name="exist", description={"Check if a mailbox exists"})
public class MailboxExistCommand
implements Callable<Integer> {
    @CommandLine.ParentCommand
    MailboxCommand mailboxCommand;
    @CommandLine.Parameters(description={"Username to be checked"})
    String userName;
    @CommandLine.Parameters(description={"Mailbox's name to be tested existence"})
    String mailboxName;

    @Override
    public Integer call() {
        try {
            MailboxClient mailboxClient = this.mailboxCommand.fullyQualifiedURL("/users");
            if (mailboxClient.doesExist(this.userName, this.mailboxName)) {
                this.mailboxCommand.out.println("The mailbox exists.");
            } else {
                this.mailboxCommand.out.println("Either the user name or the mailbox does not exist.");
            }
            return 0;
        }
        catch (Exception e) {
            if (e instanceof JamesFeignException) {
                this.mailboxCommand.err.println(e.getMessage());
            } else {
                e.printStackTrace(this.mailboxCommand.err);
            }
            return 1;
        }
    }
}

