/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.httpclient;

import feign.Response;
import org.apache.james.webadmin.httpclient.FeignHelper;
import org.apache.james.webadmin.httpclient.feign.QuotaFeignClient;

public class QuotaClient {
    private final QuotaFeignClient feignClient;

    public QuotaClient(QuotaFeignClient feignClient) {
        this.feignClient = feignClient;
    }

    public Long getQuotaCount() {
        return this.feignClient.getQuotaCount();
    }

    public Long getQuotaSize() {
        return this.feignClient.getQuotaSize();
    }

    public void setQuotaCount(Long count) {
        try (Response response = this.feignClient.setQuotaCount(count);){
            FeignHelper.checkResponse(response.status() == 204, "Set quota count failed. " + FeignHelper.extractBody(response));
        }
    }

    public void setQuotaSize(Long size) {
        try (Response response = this.feignClient.setQuotaSize(size);){
            FeignHelper.checkResponse(response.status() == 204, "Set quota size failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteQuotaCount() {
        try (Response response = this.feignClient.deleteQuotaCount();){
            FeignHelper.checkResponse(response.status() == 204, "Delete quota count failed. " + FeignHelper.extractBody(response));
        }
    }

    public void deleteQuotaSize() {
        try (Response response = this.feignClient.deleteQuotaSize();){
            FeignHelper.checkResponse(response.status() == 204, "Delete quota size failed. " + FeignHelper.extractBody(response));
        }
    }
}

