/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.integration;

import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import org.apache.james.GuiceJamesServer;
import org.apache.james.util.Port;
import org.apache.james.utils.WebAdminGuiceProbe;
import org.apache.james.webadmin.WebAdminUtils;
import org.hamcrest.core.IsNot;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public abstract class AuthorizedEndpointsTest {
    @BeforeEach
    void setUp(GuiceJamesServer guiceJamesServer) {
        WebAdminGuiceProbe webAdminGuiceProbe = (WebAdminGuiceProbe)guiceJamesServer.getProbe(WebAdminGuiceProbe.class);
        RestAssured.requestSpecification = WebAdminUtils.buildRequestSpecification((Port)webAdminGuiceProbe.getWebAdminPort()).build();
    }

    @Test
    void getHealthchecksShouldNotNeedAuthentication() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/healthcheck", new Object[0])).then()).statusCode(IsNot.not((Object)401));
    }

    @Test
    void getMetricsShouldNotNeedAuthentication() {
        ((ValidatableResponse)((Response)RestAssured.when().get("/metrics", new Object[0])).then()).statusCode(IsNot.not((Object)401));
    }
}

