/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.utils;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import org.apache.james.utils.SmtpSendingStep;

public class SMTPSendingException
extends RuntimeException {
    private final SmtpSendingStep sendingStep;
    private final String lastServerMessage;

    public static boolean isForStep(Throwable t, SmtpSendingStep step) {
        if (t instanceof SMTPSendingException) {
            SMTPSendingException e = (SMTPSendingException)t;
            return e.sendingStep.equals((Object)step);
        }
        return false;
    }

    private static String sanitizeString(String lastServerMessage) {
        List lines = Splitter.on((String)"\r\n").trimResults().omitEmptyStrings().splitToList((CharSequence)lastServerMessage);
        return Joiner.on((String)"\n").skipNulls().join((Iterable)lines);
    }

    public SMTPSendingException(SmtpSendingStep sendingStep, String lastServerMessage) {
        super(String.format("Error upon step %s: %s", new Object[]{sendingStep, lastServerMessage}));
        this.sendingStep = sendingStep;
        this.lastServerMessage = SMTPSendingException.sanitizeString(lastServerMessage);
    }

    public final boolean equals(Object o) {
        if (o instanceof SMTPSendingException) {
            SMTPSendingException that = (SMTPSendingException)o;
            return Objects.equals((Object)this.sendingStep, (Object)that.sendingStep) && Objects.equals(this.lastServerMessage, that.lastServerMessage);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.sendingStep, this.lastServerMessage});
    }
}

