/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.junit;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.james.util.concurrent.NamedThreadFactory;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;

public class ExecutorExtension
implements ParameterResolver,
BeforeEachCallback,
AfterEachCallback {
    private ExecutorService executorService;

    public void beforeEach(ExtensionContext context) throws Exception {
        NamedThreadFactory threadFactory = NamedThreadFactory.withClassName(this.getClass());
        this.executorService = Executors.newCachedThreadPool((ThreadFactory)threadFactory);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType() == ExecutorService.class;
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.executorService;
    }

    public void afterEach(ExtensionContext context) throws Exception {
        this.executorService.shutdownNow();
    }
}

