/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mailbox.postgres.search;

import jakarta.inject.Inject;
import jakarta.mail.Flags;
import org.apache.james.backends.postgres.utils.PostgresExecutor;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageUid;
import org.apache.james.mailbox.model.Mailbox;
import org.apache.james.mailbox.model.SearchQuery;
import org.apache.james.mailbox.postgres.PostgresMailboxId;
import org.apache.james.mailbox.postgres.mail.dao.PostgresMailboxMessageDAO;
import org.apache.james.mailbox.store.search.ListeningMessageSearchIndex;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DeletedSearchOverride
implements ListeningMessageSearchIndex.SearchOverride {
    private final PostgresExecutor.Factory executorFactory;

    @Inject
    public DeletedSearchOverride(PostgresExecutor.Factory executorFactory) {
        this.executorFactory = executorFactory;
    }

    public boolean applicable(SearchQuery searchQuery, MailboxSession session) {
        return searchQuery.getCriteria().size() == 1 && ((SearchQuery.Criterion)searchQuery.getCriteria().get(0)).equals(SearchQuery.flagIsSet((Flags.Flag)Flags.Flag.DELETED)) && searchQuery.getSorts().equals(SearchQuery.DEFAULT_SORTS);
    }

    public Flux<MessageUid> search(MailboxSession session, Mailbox mailbox, SearchQuery searchQuery) {
        return Mono.fromCallable(() -> new PostgresMailboxMessageDAO(this.executorFactory.create(session.getUser().getDomainPart()))).flatMapMany(dao -> dao.findDeletedMessagesByMailboxId((PostgresMailboxId)mailbox.getMailboxId()));
    }
}

