/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor.fetch;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

class PartialWritableByteChannel
implements WritableByteChannel {
    private final WritableByteChannel delegate;
    private final long firstOctet;
    private final long numberOfOctets;
    private long bytesWritten;

    public PartialWritableByteChannel(WritableByteChannel delegate, long firstOctet, long numberOfOctets) {
        this.delegate = delegate;
        this.firstOctet = firstOctet;
        this.numberOfOctets = numberOfOctets;
        this.bytesWritten = 0L;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int result;
        long bytesToIgnore = this.firstOctet - this.bytesWritten;
        if (bytesToIgnore > 0L) {
            int remaining = src.remaining();
            if ((long)remaining <= bytesToIgnore) {
                result = this.ignoreRemaining(src);
            } else {
                int remainingBytesToIgnore = (int)bytesToIgnore;
                src.position(src.position() + remainingBytesToIgnore);
                result = this.writeRemaining(src, this.numberOfOctets) + remainingBytesToIgnore;
            }
        } else {
            long bytesToWrite = this.numberOfOctets - this.bytesWritten + this.firstOctet;
            result = this.writeRemaining(src, bytesToWrite);
        }
        this.bytesWritten += (long)result;
        return result;
    }

    private int writeRemaining(ByteBuffer src, long bytesToWrite) throws IOException {
        int result;
        int remaining = src.remaining();
        if (bytesToWrite <= 0L) {
            result = this.ignoreRemaining(src);
        } else if ((long)remaining < bytesToWrite) {
            result = this.delegate.write(src);
        } else {
            ByteBuffer slice = src.asReadOnlyBuffer();
            slice.limit(slice.position() + (int)bytesToWrite);
            this.delegate.write(slice);
            result = this.ignoreRemaining(src);
        }
        return result;
    }

    private int ignoreRemaining(ByteBuffer src) {
        int result = src.remaining();
        src.position(src.limit());
        return result;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }
}

