/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.ImapResponseMessage;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.message.request.CompressRequest;
import org.apache.james.imap.processor.CapabilityImplementingProcessor;
import org.apache.james.imap.processor.base.AbstractChainedProcessor;

public class CompressProcessor
extends AbstractChainedProcessor<CompressRequest>
implements CapabilityImplementingProcessor {
    private static final String ALGO = "DEFLATE";
    private static final List<String> CAPA = Arrays.asList("COMPRESS=DEFLATE");
    private StatusResponseFactory factory;
    private static final String COMPRESSED = "COMPRESSED";

    public CompressProcessor(ImapProcessor next, StatusResponseFactory factory) {
        super(CompressRequest.class, next);
        this.factory = factory;
    }

    @Override
    protected void doProcess(CompressRequest request, ImapProcessor.Responder responder, ImapSession session) {
        if (session.isCompressionSupported()) {
            Object obj = session.getAttribute(COMPRESSED);
            if (obj != null) {
                responder.respond((ImapResponseMessage)this.factory.taggedNo(request.getTag(), request.getCommand(), HumanReadableText.COMPRESS_ALREADY_ACTIVE));
            } else if (!request.getAlgorithm().equalsIgnoreCase(ALGO)) {
                responder.respond((ImapResponseMessage)this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.ILLEGAL_ARGUMENTS));
            } else {
                responder.respond((ImapResponseMessage)this.factory.taggedOk(request.getTag(), request.getCommand(), HumanReadableText.DEFLATE_ACTIVE));
                if (session.startCompression()) {
                    session.setAttribute(COMPRESSED, (Object)true);
                }
            }
        } else {
            responder.respond((ImapResponseMessage)this.factory.taggedBad(request.getTag(), request.getCommand(), HumanReadableText.UNKNOWN_COMMAND));
        }
    }

    @Override
    public List<String> getImplementedCapabilities(ImapSession session) {
        if (session.isCompressionSupported()) {
            return CAPA;
        }
        return Collections.EMPTY_LIST;
    }
}

