/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.encode;

import java.io.IOException;
import java.util.Iterator;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.encode.ImapEncoder;
import org.apache.james.imap.encode.ImapResponseComposer;
import org.apache.james.imap.encode.base.AbstractChainedImapEncoder;
import org.apache.james.imap.message.response.CapabilityResponse;

public class CapabilityResponseEncoder
extends AbstractChainedImapEncoder {
    public CapabilityResponseEncoder(ImapEncoder next) {
        super(next);
    }

    @Override
    protected void doEncode(ImapMessage acceptableMessage, ImapResponseComposer composer, ImapSession session) throws IOException {
        CapabilityResponse response = (CapabilityResponse)acceptableMessage;
        Iterator<String> capabilities = response.getCapabilities().iterator();
        composer.untagged();
        composer.message("CAPABILITY");
        while (capabilities.hasNext()) {
            composer.message(capabilities.next());
        }
        composer.end();
    }

    @Override
    protected boolean isAcceptable(ImapMessage message) {
        return message instanceof CapabilityResponse;
    }
}

