/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.decode.parser;

import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.ImapMessage;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.StatusDataItems;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.decode.DecodingException;
import org.apache.james.imap.decode.ImapRequestLineReader;
import org.apache.james.imap.decode.base.AbstractImapCommandParser;
import org.apache.james.imap.message.request.StatusRequest;

public class StatusCommandParser
extends AbstractImapCommandParser {
    public StatusCommandParser() {
        super(ImapCommand.authenticatedStateCommand((String)"STATUS"));
    }

    StatusDataItems statusDataItems(ImapRequestLineReader request) throws DecodingException {
        StatusDataItems items = new StatusDataItems();
        request.nextWordChar();
        request.consumeChar('(');
        ImapRequestLineReader.NoopCharValidator validator = new ImapRequestLineReader.NoopCharValidator();
        String nextWord = request.consumeWord(validator);
        while (!nextWord.endsWith(")")) {
            this.addItem(nextWord, items);
            nextWord = request.consumeWord(validator);
        }
        if (nextWord.length() > 1) {
            this.addItem(nextWord.substring(0, nextWord.length() - 1), items);
        }
        return items;
    }

    private void addItem(String nextWord, StatusDataItems items) throws DecodingException {
        if (nextWord.equalsIgnoreCase("MESSAGES")) {
            items.setMessages(true);
        } else if (nextWord.equalsIgnoreCase("RECENT")) {
            items.setRecent(true);
        } else if (nextWord.equalsIgnoreCase("UIDNEXT")) {
            items.setUidNext(true);
        } else if (nextWord.equalsIgnoreCase("UIDVALIDITY")) {
            items.setUidValidity(true);
        } else if (nextWord.equalsIgnoreCase("UNSEEN")) {
            items.setUnseen(true);
        } else if (nextWord.equalsIgnoreCase("HIGHESTMODSEQ")) {
            items.setHighestModSeq(true);
        } else {
            throw new DecodingException(HumanReadableText.ILLEGAL_ARGUMENTS, "Unknown status item: '" + nextWord + "'");
        }
    }

    @Override
    protected ImapMessage decode(ImapCommand command, ImapRequestLineReader request, String tag, ImapSession session) throws DecodingException {
        String mailboxName = request.mailbox();
        StatusDataItems statusDataItems = this.statusDataItems(request);
        request.eol();
        return new StatusRequest(command, mailboxName, statusDataItems, tag);
    }
}

