/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec.client;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import java.net.URL;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.util.DurationParser;

public class CrowdsecClientConfiguration {
    public static final String DEFAULT_API_KEY = "default_api_key";
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMillis(500L);
    private static final Duration TEST_TIMEOUT = Duration.ofSeconds(5L);
    private final URL url;
    private final String apiKey;
    private final Duration timeout;

    public static CrowdsecClientConfiguration from(Configuration config) {
        URL crowdsecUrl = (URL)Optional.ofNullable(config.getString("crowdsecUrl", null)).filter(s -> !s.isEmpty()).map(Throwing.function(URL::new)).orElseThrow(() -> new IllegalArgumentException("Crowdsec's url is invalid."));
        String apiKey = Optional.of(config.getString("apiKey")).orElseThrow(() -> new IllegalArgumentException("Missing CrowdSec apiKey!"));
        Duration timeout = Optional.ofNullable(config.getString("timeout", null)).map(value -> DurationParser.parse((String)value, (ChronoUnit)ChronoUnit.SECONDS)).orElse(DEFAULT_TIMEOUT);
        return new CrowdsecClientConfiguration(crowdsecUrl, apiKey, timeout);
    }

    public CrowdsecClientConfiguration(URL url, String apiKey, Duration timeout) {
        this.url = url;
        this.apiKey = apiKey;
        this.timeout = timeout;
    }

    @VisibleForTesting
    public CrowdsecClientConfiguration(URL url, String apiKey) {
        this.url = url;
        this.apiKey = apiKey;
        this.timeout = TEST_TIMEOUT;
    }

    public URL getUrl() {
        return this.url;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public Duration getTimeout() {
        return this.timeout;
    }
}

