/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.crowdsec;

import jakarta.inject.Inject;
import java.util.List;
import org.apache.james.crowdsec.CrowdsecUtils;
import org.apache.james.crowdsec.client.CrowdsecHttpClient;
import org.apache.james.crowdsec.model.CrowdsecDecision;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ConnectHandler;
import org.apache.james.protocols.pop3.POP3Response;
import org.apache.james.protocols.pop3.POP3Session;

public class CrowdsecPOP3CheckHandler
implements ConnectHandler<POP3Session> {
    private final CrowdsecHttpClient crowdsecHttpClient;

    @Inject
    public CrowdsecPOP3CheckHandler(CrowdsecHttpClient crowdsecHttpClient) {
        this.crowdsecHttpClient = crowdsecHttpClient;
    }

    public Response onConnect(POP3Session session) {
        String realClientIp = session.getLocalAddress().getAddress().getHostAddress();
        return (Response)this.crowdsecHttpClient.getCrowdsecDecisions().map(decisions -> this.toResponse((List<CrowdsecDecision>)decisions, realClientIp)).block();
    }

    private Response toResponse(List<CrowdsecDecision> decisions, String ip) {
        if (decisions.stream().anyMatch(decision -> CrowdsecUtils.isBanned(decision, ip))) {
            return Response.DISCONNECT;
        }
        return POP3Response.OK;
    }
}

