/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.redis;

import io.lettuce.core.ReadFrom;
import io.lettuce.core.RedisCredentials;
import io.lettuce.core.RedisCredentialsProvider;
import io.lettuce.core.RedisURI;
import java.io.Serializable;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.redis.RedisConfiguration$;
import org.apache.james.backends.redis.RedisUris$;
import org.apache.james.backends.redis.SSLConfiguration;
import org.apache.james.backends.redis.SSLConfiguration$;
import org.apache.james.backends.redis.SentinelRedisConfiguration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class SentinelRedisConfiguration$
implements Serializable {
    public static final SentinelRedisConfiguration$ MODULE$ = new SentinelRedisConfiguration$();

    public SentinelRedisConfiguration from(Configuration config) {
        return this.from(Predef$.MODULE$.wrapRefArray((Object[])config.getStringArray(RedisUris$.MODULE$.REDIS_URL_PROPERTY_NAME())).mkString(","), RedisConfiguration$.MODULE$.redisUseSsl(config), SSLConfiguration$.MODULE$.from(config), RedisConfiguration$.MODULE$.redisReadFrom(config), (Option<String>)Option$.MODULE$.apply((Object)config.getString(RedisConfiguration$.MODULE$.REDIS_SENTINEL_PASSWORD(), null)), RedisConfiguration$.MODULE$.redisIoThreadsFrom(config), RedisConfiguration$.MODULE$.redisWorkerThreadsFrom(config));
    }

    public SentinelRedisConfiguration from(String redisUri, ReadFrom readFrom, String sentinelPassword) {
        return this.from(redisUri, false, (Option<SSLConfiguration>)None$.MODULE$, readFrom, (Option<String>)Option$.MODULE$.apply((Object)sentinelPassword), (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public SentinelRedisConfiguration from(String redisUri, SSLConfiguration sslConfiguration, ReadFrom readFrom) {
        return this.from(redisUri, true, (Option<SSLConfiguration>)new Some((Object)sslConfiguration), readFrom, (Option<String>)None$.MODULE$, (Option<Object>)None$.MODULE$, (Option<Object>)None$.MODULE$);
    }

    public SentinelRedisConfiguration from(String redisUriString, boolean useSSL, Option<SSLConfiguration> mayBeSSLConfiguration, ReadFrom readFrom, Option<String> maybeSentinelPassword, Option<Object> ioThreads, Option<Object> workerThreads) {
        RedisURI redisURI = RedisURI.create((String)redisUriString);
        maybeSentinelPassword.foreach((Function1 & Serializable)password -> {
            SentinelRedisConfiguration$.$anonfun$from$3(redisURI, password);
            return BoxedUnit.UNIT;
        });
        return new SentinelRedisConfiguration(redisURI, useSSL, mayBeSSLConfiguration, readFrom, ioThreads, workerThreads);
    }

    public Option<Object> from$default$6() {
        return None$.MODULE$;
    }

    public Option<Object> from$default$7() {
        return None$.MODULE$;
    }

    public SentinelRedisConfiguration apply(RedisURI redisURI, boolean useSSL, Option<SSLConfiguration> mayBeSSLConfiguration, ReadFrom readFrom, Option<Object> ioThreads, Option<Object> workerThreads) {
        return new SentinelRedisConfiguration(redisURI, useSSL, mayBeSSLConfiguration, readFrom, ioThreads, workerThreads);
    }

    public Option<Tuple6<RedisURI, Object, Option<SSLConfiguration>, ReadFrom, Option<Object>, Option<Object>>> unapply(SentinelRedisConfiguration x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple6((Object)x$0.redisURI(), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.useSSL()), x$0.mayBeSSLConfiguration(), (Object)x$0.readFrom(), x$0.ioThreads(), x$0.workerThreads()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SentinelRedisConfiguration$.class);
    }

    public static final /* synthetic */ void $anonfun$from$3(RedisURI redisURI$1, String password) {
        redisURI$1.getSentinels().forEach(uri -> uri.setCredentialsProvider(RedisCredentialsProvider.from(() -> RedisCredentials.just((String)"", (CharSequence)password))));
    }

    private SentinelRedisConfiguration$() {
    }
}

