/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.redis;

import io.lettuce.core.ReadFrom;
import java.io.File;
import java.io.Serializable;
import org.apache.commons.configuration2.Configuration;
import org.apache.james.backends.redis.ClusterRedisConfiguration$;
import org.apache.james.backends.redis.MasterReplicaRedisConfiguration$;
import org.apache.james.backends.redis.RedisConfiguration;
import org.apache.james.backends.redis.SentinelRedisConfiguration$;
import org.apache.james.backends.redis.StandaloneRedisConfiguration;
import org.apache.james.backends.redis.StandaloneRedisConfiguration$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.runtime.BoxesRunTime;

public final class RedisConfiguration$ {
    public static final RedisConfiguration$ MODULE$ = new RedisConfiguration$();
    private static final String REDIS_READ_FROM_PROPERTY_NAME = "redis.readFrom";
    private static final String REDIS_SENTINEL_PASSWORD = "redis.sentinelPassword";
    private static final String REDIS_USE_SSL = "redis.ssl.enabled";
    private static final String REDIS_IGNORE_CERTIFICATE_CHECK = "redis.ignoreCertificateCheck";
    private static final String REDIS_KEY_STORE_FILE_PATH_PROPERTY_NAME = "redis.keystore.file.path";
    private static final String REDIS_KEY_STORE_PASSWORD_PROPERTY_NAME = "redis.keystore.password";
    private static final String STANDALONE_TOPOLOGY = "standalone";
    private static final String CLUSTER_TOPOLOGY = "cluster";
    private static final String MASTER_REPLICA_TOPOLOGY = "master-replica";
    private static final String SENTINEL_TOPOLOGY = "sentinel";
    private static final ReadFrom REDIS_READ_FROM_DEFAULT_VALUE = ReadFrom.MASTER;
    private static final boolean REDIS_USE_SSL_DEFAULT_VALUE = false;
    private static final boolean REDIS_IGNORE_CERTIFICATE_CHECK_DEFAULT_VALUE = true;
    private static final String KEY_STORE_FILE_PATH_DEFAULT_VALUE = "file://" + System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
    private static final String KEY_STORE_PASSWORD_DEFAULT_VALUE = "";
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisConfiguration.class);

    public String REDIS_READ_FROM_PROPERTY_NAME() {
        return REDIS_READ_FROM_PROPERTY_NAME;
    }

    public String REDIS_SENTINEL_PASSWORD() {
        return REDIS_SENTINEL_PASSWORD;
    }

    public String REDIS_USE_SSL() {
        return REDIS_USE_SSL;
    }

    public String REDIS_IGNORE_CERTIFICATE_CHECK() {
        return REDIS_IGNORE_CERTIFICATE_CHECK;
    }

    public String REDIS_KEY_STORE_FILE_PATH_PROPERTY_NAME() {
        return REDIS_KEY_STORE_FILE_PATH_PROPERTY_NAME;
    }

    public String REDIS_KEY_STORE_PASSWORD_PROPERTY_NAME() {
        return REDIS_KEY_STORE_PASSWORD_PROPERTY_NAME;
    }

    public String STANDALONE_TOPOLOGY() {
        return STANDALONE_TOPOLOGY;
    }

    public String CLUSTER_TOPOLOGY() {
        return CLUSTER_TOPOLOGY;
    }

    public String MASTER_REPLICA_TOPOLOGY() {
        return MASTER_REPLICA_TOPOLOGY;
    }

    public String SENTINEL_TOPOLOGY() {
        return SENTINEL_TOPOLOGY;
    }

    public ReadFrom REDIS_READ_FROM_DEFAULT_VALUE() {
        return REDIS_READ_FROM_DEFAULT_VALUE;
    }

    public boolean REDIS_USE_SSL_DEFAULT_VALUE() {
        return REDIS_USE_SSL_DEFAULT_VALUE;
    }

    public boolean REDIS_IGNORE_CERTIFICATE_CHECK_DEFAULT_VALUE() {
        return REDIS_IGNORE_CERTIFICATE_CHECK_DEFAULT_VALUE;
    }

    public String KEY_STORE_FILE_PATH_DEFAULT_VALUE() {
        return KEY_STORE_FILE_PATH_DEFAULT_VALUE;
    }

    public String KEY_STORE_PASSWORD_DEFAULT_VALUE() {
        return KEY_STORE_PASSWORD_DEFAULT_VALUE;
    }

    public Logger LOGGER() {
        return LOGGER;
    }

    public Option<Object> redisIoThreadsFrom(Configuration config) {
        return Option$.MODULE$.apply((Object)config.getInteger("redis.ioThreads", null)).map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)));
    }

    public Option<Object> redisWorkerThreadsFrom(Configuration config) {
        return Option$.MODULE$.apply((Object)config.getInteger("redis.workerThreads", null)).map((Function1 & Serializable)x -> BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(x)));
    }

    public ReadFrom redisReadFrom(Configuration config) {
        return (ReadFrom)Option$.MODULE$.apply((Object)config.getString(this.REDIS_READ_FROM_PROPERTY_NAME(), null)).map((Function1 & Serializable)x$1 -> ReadFrom.valueOf((String)x$1)).getOrElse((Function0 & Serializable)() -> MODULE$.REDIS_READ_FROM_DEFAULT_VALUE());
    }

    public boolean redisUseSsl(Configuration config) {
        return config.getBoolean(this.REDIS_USE_SSL(), this.REDIS_USE_SSL_DEFAULT_VALUE());
    }

    public RedisConfiguration from(Configuration config) {
        Product product;
        String string = config.getString("redis.topology", this.STANDALONE_TOPOLOGY());
        String string2 = this.STANDALONE_TOPOLOGY();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            product = StandaloneRedisConfiguration$.MODULE$.from(config);
        } else {
            String string4 = this.CLUSTER_TOPOLOGY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                product = ClusterRedisConfiguration$.MODULE$.from(config);
            } else {
                String string6 = this.MASTER_REPLICA_TOPOLOGY();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    product = MasterReplicaRedisConfiguration$.MODULE$.from(config);
                } else {
                    String string8 = this.SENTINEL_TOPOLOGY();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        product = SentinelRedisConfiguration$.MODULE$.from(config);
                    } else {
                        throw new IllegalArgumentException("Invalid topology");
                    }
                }
            }
        }
        StandaloneRedisConfiguration redisConfiguration = product;
        this.LOGGER().info("Configured Redis with: " + redisConfiguration.asString());
        return redisConfiguration;
    }

    private RedisConfiguration$() {
    }
}

