/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.Collection;
import java.util.Collections;
import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.fs.spi.ACLManagement;
import org.apache.jackrabbit.vault.fs.spi.impl.jcr20.JackrabbitACLManagement;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AccessControlValidator
implements DocumentViewXmlValidator {
    protected static final ACLManagement ACL_MANAGEMENT = new JackrabbitACLManagement();
    protected static final String MESSAGE_IGNORED_ACCESS_CONTROL_LIST = "Found an access control list, but it is never considered during installation as the property 'acHandling' is set to '%s'!";
    protected static final String MESSAGE_INEFFECTIVE_ACCESS_CONTROL_LIST = "Found no access control list, but there is supposed to be one contained as the property 'acHandling' is set to '%s'!";
    private final ValidationMessageSeverity severity;
    private final AccessControlHandling accessControlHandling;
    private boolean hasFoundACLNode;
    private final boolean isIncremental;

    public AccessControlValidator(boolean isIncremental, ValidationMessageSeverity severity, AccessControlHandling accessControlHandling) {
        this.severity = severity;
        this.accessControlHandling = accessControlHandling;
        this.hasFoundACLNode = false;
        this.isIncremental = isIncremental;
    }

    @Override
    public Collection<ValidationMessage> done() {
        if (!this.isIncremental && !this.hasFoundACLNode && this.accessControlHandling != AccessControlHandling.IGNORE && this.accessControlHandling != AccessControlHandling.CLEAR) {
            return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_INEFFECTIVE_ACCESS_CONTROL_LIST, this.accessControlHandling)));
        }
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (ACL_MANAGEMENT.isACLNodeType(node.getPrimaryType().orElse(""))) {
            this.hasFoundACLNode = true;
            if (this.accessControlHandling == AccessControlHandling.IGNORE || this.accessControlHandling == AccessControlHandling.CLEAR) {
                return Collections.singleton(new ValidationMessage(this.severity, String.format(MESSAGE_IGNORED_ACCESS_CONTROL_LIST, this.accessControlHandling)));
            }
        }
        return null;
    }
}

