/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.apache.felix.cm.file.ConfigurationHandler;
import org.apache.felix.cm.json.ConfigurationReader;
import org.apache.felix.cm.json.Configurations;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.apache.jackrabbit.vault.util.DocViewNode2;
import org.apache.jackrabbit.vault.util.DocViewProperty2;
import org.apache.jackrabbit.vault.util.UncheckedRepositoryException;
import org.apache.jackrabbit.vault.validation.ValidationExecutor;
import org.apache.jackrabbit.vault.validation.impl.util.ValidatorException;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.GenericJcrDataValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.OsgiConfigurationValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OsgiConfigurationParserValidator
implements DocumentViewXmlValidator,
GenericJcrDataValidator {
    private static final String SLING_OSGI_CONFIG_NODETYPE = "sling:OsgiConfig";
    private static final String OSGI_CONFIG_NODE_PATH = "/(?:[^/]*/){0,4}?config(?:\\.[^/]*)?/.*";
    private static final Pattern OSGI_CONFIG_NODE_PATH_PATTERN = Pattern.compile("/(?:[^/]*/){0,4}?config(?:\\.[^/]*)?/.*");
    private static final Pattern OSGI_CONFIG_BINARY_NODE_PATH_PATTERN = Pattern.compile("/(?:[^/]*/){0,4}?config(?:\\.[^/]*)?/.*\\.(config|cfg\\.json|cfg)");
    private final Map<String, OsgiConfigurationValidator> osgiConfigurationValidators = new HashMap<String, OsgiConfigurationValidator>();
    private static final ValueFactory VALUE_FACTORY = ValueFactoryImpl.getInstance();

    @Override
    @Nullable
    public Collection<ValidationMessage> done() {
        return null;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull DocViewNode2 node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (SLING_OSGI_CONFIG_NODETYPE.equals(node.getPrimaryType().orElse("")) && OSGI_CONFIG_NODE_PATH_PATTERN.matcher(nodeContext.getNodePath()).matches()) {
            Map<String, Object> configuration = this.deserializeOsgiConfiguration(node);
            Map.Entry<String, String> pidAndSubname = OsgiConfigurationParserValidator.extractPidAndSubnameFromName(Text.getName((String)nodeContext.getNodePath()), OsgiConfigurationSerializationFormat.NT_OSGI_CONFIG);
            return this.validateConfig(configuration, OsgiConfigurationSerializationFormat.NT_OSGI_CONFIG, pidAndSubname.getKey(), pidAndSubname.getValue(), nodeContext.getNodePath());
        }
        return null;
    }

    static Optional<Object> convertValue(String v, int type) {
        Value value;
        if (type == 0) {
            type = 1;
        }
        try {
            value = VALUE_FACTORY.createValue(v, type);
        }
        catch (ValueFormatException e) {
            throw new UncheckedRepositoryException((RepositoryException)((Object)e));
        }
        return OsgiConfigurationParserValidator.convertValue(value);
    }

    private static Optional<Object> convertValue(Value v) {
        Object object;
        try {
            switch (v.getType()) {
                case 1: {
                    object = v.getString();
                    break;
                }
                case 5: {
                    object = v.getDate();
                    break;
                }
                case 4: {
                    object = v.getDouble();
                    break;
                }
                case 3: {
                    object = v.getLong();
                    break;
                }
                case 6: {
                    object = v.getBoolean();
                    break;
                }
                default: {
                    object = null;
                    break;
                }
            }
        }
        catch (RepositoryException e) {
            throw new UncheckedRepositoryException(e);
        }
        return Optional.ofNullable(object);
    }

    static Map.Entry<String, String> extractPidAndSubnameFromName(String name, OsgiConfigurationSerializationFormat format) {
        String subname;
        String pid;
        switch (format) {
            case CFG: {
                name = name.substring(0, name.length() - ".cfg".length());
                break;
            }
            case CFG_JSON: {
                name = name.substring(0, name.length() - ".cfg.json".length());
                break;
            }
            case CONFIG: {
                name = name.substring(0, name.length() - ".config".length());
                break;
            }
        }
        int separatorPos = name.lastIndexOf(126);
        if (separatorPos == -1) {
            separatorPos = name.lastIndexOf(45);
        }
        if (separatorPos == -1) {
            pid = name;
            subname = null;
        } else {
            pid = name.substring(0, separatorPos);
            subname = name.substring(separatorPos + 1);
        }
        return new AbstractMap.SimpleEntry<String, Object>(pid, subname);
    }

    @Override
    public boolean shouldValidateJcrData(@NotNull Path filePath, @NotNull Path basePath) {
        return this.isBinaryOsgiConfig(ValidationExecutor.filePathToNodePath(filePath));
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validateJcrData(@NotNull InputStream input, @NotNull Path filePath, @NotNull Path basePath, @NotNull Map<String, Integer> nodePathsAndLineNumbers) throws IOException {
        String nodePath = ValidationExecutor.filePathToNodePath(filePath);
        OsgiConfigurationSerializationFormat type = OsgiConfigurationParserValidator.getType(Text.getName((String)nodePath));
        Map<String, Object> config = this.deserializeOsgiConfiguration(type, input);
        Map.Entry<String, String> pidAndSubname = OsgiConfigurationParserValidator.extractPidAndSubnameFromName(filePath.getFileName().toString(), type);
        return this.validateConfig(config, type, pidAndSubname.getKey(), pidAndSubname.getValue(), nodePath);
    }

    @NotNull
    private Collection<ValidationMessage> validateConfig(Map<String, Object> config, OsgiConfigurationSerializationFormat type, String pid, String subname, String nodePath) {
        @NotNull LinkedList<ValidationMessage> allMessages = new LinkedList<ValidationMessage>();
        for (Map.Entry<String, OsgiConfigurationValidator> entry : this.osgiConfigurationValidators.entrySet()) {
            try {
                Collection<ValidationMessage> messages = entry.getValue().validateConfig(config, pid, subname, nodePath);
                if (messages == null || messages.isEmpty()) continue;
                allMessages.addAll(messages);
            }
            catch (RuntimeException e) {
                throw new ValidatorException(entry.getKey(), e);
            }
        }
        return allMessages;
    }

    @NotNull
    static OsgiConfigurationSerializationFormat getType(String nodeName) {
        if (nodeName.endsWith(".cfg.json")) {
            return OsgiConfigurationSerializationFormat.CFG_JSON;
        }
        if (nodeName.endsWith(".config")) {
            return OsgiConfigurationSerializationFormat.CONFIG;
        }
        if (nodeName.endsWith(".cfg")) {
            return OsgiConfigurationSerializationFormat.CFG;
        }
        throw new IllegalArgumentException("Given file name " + nodeName + " does not represent a known OSGi configuration serialization");
    }

    private boolean isBinaryOsgiConfig(@NotNull String nodePath) {
        return OSGI_CONFIG_BINARY_NODE_PATH_PATTERN.matcher(nodePath).matches();
    }

    Map<String, Object> deserializeOsgiConfiguration(@NotNull OsgiConfigurationSerializationFormat serializationType, @NotNull InputStream input) throws IOException {
        try {
            switch (serializationType) {
                case CONFIG: {
                    return OsgiConfigurationParserValidator.convertToMap(ConfigurationHandler.read((InputStream)input));
                }
                case CFG: {
                    Properties properties = new Properties();
                    properties.load(input);
                    return OsgiConfigurationParserValidator.convertToMap(properties);
                }
                case CFG_JSON: {
                    InputStreamReader reader = new InputStreamReader(input, StandardCharsets.UTF_8);
                    ConfigurationReader configReader = Configurations.buildReader().build((Reader)reader);
                    return OsgiConfigurationParserValidator.convertToMap(configReader.readConfiguration());
                }
            }
            throw new IllegalArgumentException("Only .cfg, .cfg.json or .config binary formats supported");
        }
        catch (NoClassDefFoundError e) {
            throw new IllegalStateException("Cannot deserialize OSGi configuration due to missing dependencies", e);
        }
    }

    Map<String, Object> deserializeOsgiConfiguration(DocViewNode2 node) {
        HashMap<String, Object> configurationMap = new HashMap<String, Object>();
        for (DocViewProperty2 property : node.getProperties()) {
            A[] data;
            if (!"".equals(property.getName().getNamespaceURI())) continue;
            if (property.isMultiValue()) {
                data = property.getStringValues().stream().map(v -> OsgiConfigurationParserValidator.convertValue(v, property.getType())).filter(Optional::isPresent).map(Optional::get).toArray(Object[]::new);
                configurationMap.put(property.getName().getLocalName(), data);
                continue;
            }
            data = property.getStringValue().map(v -> OsgiConfigurationParserValidator.convertValue(v, property.getType())).orElse(Optional.empty()).orElse(null);
            if (data == null) continue;
            configurationMap.put(property.getName().getLocalName(), data);
        }
        return configurationMap;
    }

    static Map<String, Object> convertToMap(Dictionary<String, ?> dictionary) {
        ArrayList<String> keys = Collections.list(dictionary.keys());
        return keys.stream().collect(Collectors.toMap(Function.identity(), dictionary::get));
    }

    static Map<String, Object> convertToMap(Properties properties) {
        return properties.entrySet().stream().collect(Collectors.toMap(e -> String.valueOf(e.getKey()), e -> String.valueOf(e.getValue()), (prev, next) -> next, HashMap::new));
    }

    public void setOsgiConfigurationValidators(Map<String, OsgiConfigurationValidator> osgiConfigurationValidators) {
        this.osgiConfigurationValidators.putAll(osgiConfigurationValidators);
    }

    static enum OsgiConfigurationSerializationFormat {
        CFG_JSON,
        CONFIG,
        CFG,
        NT_OSGI_CONFIG;

    }
}

