/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.jackrabbit.vault.fs.api.ImportMode;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.util.DocViewNode;
import org.apache.jackrabbit.vault.validation.spi.DocumentViewXmlValidator;
import org.apache.jackrabbit.vault.validation.spi.NodeContext;
import org.apache.jackrabbit.vault.validation.spi.NodePathValidator;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessage;
import org.apache.jackrabbit.vault.validation.spi.ValidationMessageSeverity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyElementsValidator
implements DocumentViewXmlValidator,
NodePathValidator {
    protected static final String MESSAGE_EMPTY_NODES = "Found empty node (used for ordering only) without an accompanying folder which are included in the filter with mode=replace. Either remove the empty node or add at least the 'jcr:primaryType' attribute to make this node really get replaced.";
    private final ValidationMessageSeverity severity;
    private final List<NodeContext> emptyNodes;
    private final List<String> nonEmptyNodePaths;
    private final WorkspaceFilter filter;
    private Collection<String> affectedFilterRoots;

    public EmptyElementsValidator(ValidationMessageSeverity severity, WorkspaceFilter filter) {
        this.severity = severity;
        this.emptyNodes = new LinkedList<NodeContext>();
        this.nonEmptyNodePaths = new LinkedList<String>();
        this.filter = filter;
        this.affectedFilterRoots = new LinkedList<String>();
        for (PathFilterSet set : filter.getPropertyFilterSets()) {
            if (set.getImportMode() != ImportMode.REPLACE) continue;
            this.affectedFilterRoots.add(set.getRoot());
        }
    }

    @Override
    public Collection<ValidationMessage> done() {
        return this.emptyNodes.stream().filter(e -> this.nonEmptyNodePaths.stream().noneMatch(n -> n.equals(e.getNodePath()))).map(e -> new ValidationMessage(this.severity, MESSAGE_EMPTY_NODES, e.getNodePath(), e.getFilePath(), e.getBasePath(), null)).collect(Collectors.toList());
    }

    @Override
    public Collection<ValidationMessage> validate(@NotNull DocViewNode node, @NotNull NodeContext nodeContext, boolean isRoot) {
        if (this.isBelowAffectedFilterRoots(nodeContext.getNodePath())) {
            if (node.primary == null && node.mixins == null && node.props.isEmpty() && this.filter.contains(nodeContext.getNodePath()) && this.filter.getImportMode(nodeContext.getNodePath()) == ImportMode.REPLACE) {
                if (!node.name.equals("rep:policy")) {
                    this.emptyNodes.add(nodeContext);
                }
            } else {
                this.nonEmptyNodePaths.add(nodeContext.getNodePath());
            }
        }
        return null;
    }

    private boolean isBelowAffectedFilterRoots(String nodePath) {
        for (String affectedFilterRoot : this.affectedFilterRoots) {
            if (!nodePath.startsWith(affectedFilterRoot)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Collection<ValidationMessage> validate(@NotNull NodeContext nodeContext) {
        if (this.isBelowAffectedFilterRoots(nodeContext.getNodePath())) {
            this.nonEmptyNodePaths.add(nodeContext.getNodePath());
        }
        return null;
    }
}

