/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.DocumentViewParserValidator;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXException;

public class DocumentViewParserValidatorFactory
implements ValidatorFactory {
    private SAXParser saxParser;

    public DocumentViewParserValidatorFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.saxParser = spf.newSAXParser();
    }

    @Override
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        return new DocumentViewParserValidator(this.saxParser, settings.getDefaultSeverity());
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return true;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-docviewparser";
    }

    @Override
    public int getServiceRanking() {
        return Integer.MAX_VALUE;
    }
}

