/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.validation.spi.impl;

import org.apache.jackrabbit.vault.fs.io.AccessControlHandling;
import org.apache.jackrabbit.vault.validation.spi.ValidationContext;
import org.apache.jackrabbit.vault.validation.spi.Validator;
import org.apache.jackrabbit.vault.validation.spi.ValidatorFactory;
import org.apache.jackrabbit.vault.validation.spi.ValidatorSettings;
import org.apache.jackrabbit.vault.validation.spi.impl.AccessControlValidator;
import org.jetbrains.annotations.NotNull;

public final class AccessControlValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(@NotNull ValidationContext context, @NotNull ValidatorSettings settings) {
        AccessControlHandling accessControlHandling = context.getProperties().getACHandling();
        return new AccessControlValidator(settings.getDefaultSeverity(), accessControlHandling);
    }

    @Override
    public boolean shouldValidateSubpackages() {
        return false;
    }

    @Override
    @NotNull
    public String getId() {
        return "jackrabbit-accesscontrol";
    }

    @Override
    public int getServiceRanking() {
        return Integer.MAX_VALUE;
    }
}

