/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.mongo;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.Block;
import com.mongodb.DBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.jackrabbit.oak.plugins.document.Collection;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.RevisionVector;
import org.apache.jackrabbit.oak.plugins.document.SplitDocumentCleanUp;
import org.apache.jackrabbit.oak.plugins.document.VersionGCSupport;
import org.apache.jackrabbit.oak.plugins.document.VersionGarbageCollector;
import org.apache.jackrabbit.oak.plugins.document.mongo.MongoDocumentStore;
import org.apache.jackrabbit.oak.plugins.document.util.CloseableIterable;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.stats.Clock;
import org.bson.conversions.Bson;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoVersionGCSupport
extends VersionGCSupport {
    private static final Logger LOG = LoggerFactory.getLogger(MongoVersionGCSupport.class);
    private final MongoDocumentStore store;
    private final int batchSize = Integer.getInteger("oak.mongo.queryDeletedDocsBatchSize", 1000);

    public MongoVersionGCSupport(MongoDocumentStore store) {
        super(store);
        this.store = store;
    }

    public CloseableIterable<NodeDocument> getPossiblyDeletedDocs(long fromModified, long toModified) {
        Bson query = Filters.and((Bson[])new Bson[]{Filters.eq((String)"_deletedOnce", (Object)true), Filters.gte((String)"_modified", (Object)NodeDocument.getModifiedInSecs(fromModified)), Filters.lt((String)"_modified", (Object)NodeDocument.getModifiedInSecs(toModified))});
        FindIterable cursor = this.getNodeCollection().find(query).batchSize(this.batchSize);
        return CloseableIterable.wrap(Iterables.transform((Iterable)cursor, input -> this.store.convertFromDBObject(Collection.NODES, (DBObject)input)));
    }

    @Override
    public long getDeletedOnceCount() {
        Bson query = Filters.eq((String)"_deletedOnce", (Object)Boolean.TRUE);
        return this.getNodeCollection().count(query);
    }

    @Override
    protected SplitDocumentCleanUp createCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
        return new MongoSplitDocCleanUp(gcTypes, sweepRevs, oldestRevTimeStamp, stats);
    }

    @Override
    protected Iterable<NodeDocument> identifyGarbage(Set<NodeDocument.SplitDocType> gcTypes, final RevisionVector sweepRevs, long oldestRevTimeStamp) {
        return Iterables.filter((Iterable)Iterables.transform((Iterable)this.getNodeCollection().find(this.createQuery(gcTypes, sweepRevs, oldestRevTimeStamp)), (Function)new Function<BasicDBObject, NodeDocument>(){

            public NodeDocument apply(BasicDBObject input) {
                return MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, (DBObject)input);
            }
        }), (Predicate)new Predicate<NodeDocument>(){

            public boolean apply(NodeDocument input) {
                return !MongoVersionGCSupport.isDefaultNoBranchSplitNewerThan(input, sweepRevs);
            }
        });
    }

    @Override
    public long getOldestDeletedOnceTimestamp(Clock clock, long precisionMs) {
        LOG.debug("getOldestDeletedOnceTimestamp() <- start");
        Bson query = Filters.eq((String)"_deletedOnce", (Object)Boolean.TRUE);
        Bson sort = Filters.eq((String)"_modified", (Object)1);
        final ArrayList<Long> result = new ArrayList<Long>(1);
        this.getNodeCollection().find(query).sort(sort).limit(1).forEach((Block)new Block<BasicDBObject>(){

            public void apply(BasicDBObject document) {
                NodeDocument doc = MongoVersionGCSupport.this.store.convertFromDBObject(Collection.NODES, (DBObject)document);
                long modifiedMs = doc.getModified() * TimeUnit.SECONDS.toMillis(1L);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("getOldestDeletedOnceTimestamp() -> {}", (Object)Utils.timestampToString(modifiedMs));
                }
                result.add(modifiedMs);
            }
        });
        if (result.isEmpty()) {
            LOG.debug("getOldestDeletedOnceTimestamp() -> none found, return current time");
            result.add(clock.getTime());
        }
        return (Long)result.get(0);
    }

    private Bson createQuery(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp) {
        ArrayList gcTypeCodes = Lists.newArrayList();
        ArrayList orClauses = Lists.newArrayList();
        for (NodeDocument.SplitDocType type : gcTypes) {
            gcTypeCodes.add(type.typeCode());
            for (Bson query : this.queriesForType(type, sweepRevs)) {
                orClauses.add(query);
            }
        }
        return Filters.and((Bson[])new Bson[]{Filters.in((String)"_sdType", (Iterable)gcTypeCodes), Filters.or((Iterable)orClauses), Filters.lt((String)"_sdMaxRevTime", (Object)NodeDocument.getModifiedInSecs(oldestRevTimeStamp))});
    }

    @NotNull
    private Iterable<Bson> queriesForType(NodeDocument.SplitDocType type, RevisionVector sweepRevs) {
        if (type != NodeDocument.SplitDocType.DEFAULT_NO_BRANCH) {
            return Collections.singletonList(Filters.eq((String)"_sdType", (Object)type.typeCode()));
        }
        ArrayList queries = Lists.newArrayList();
        for (Revision r : sweepRevs) {
            String idSuffix = Utils.getPreviousIdFor("/", r, 0);
            idSuffix = idSuffix.substring(idSuffix.lastIndexOf(45));
            Bson idPathClause = Filters.or((Bson[])new Bson[]{Filters.regex((String)"_id", (Pattern)Pattern.compile(".*" + idSuffix)), Filters.and((Bson[])new Bson[]{Filters.regex((String)"_id", (Pattern)Pattern.compile("[^-]*")), Filters.regex((String)"_path", (Pattern)Pattern.compile(".*" + idSuffix))})});
            queries.add(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_sdType", (Object)type.typeCode()), idPathClause, Filters.lt((String)"_sdMaxRevTime", (Object)NodeDocument.getModifiedInSecs(r.getTimestamp()))}));
        }
        return queries;
    }

    private void logSplitDocIdsTobeDeleted(Bson query) {
        BasicDBObject keys = new BasicDBObject("_id", (Object)1);
        ArrayList ids = new ArrayList();
        this.getNodeCollection().withReadPreference(this.store.getConfiguredReadPreference(Collection.NODES)).find(query).projection((Bson)keys).forEach(doc -> ids.add(MongoVersionGCSupport.getID(doc)));
        StringBuilder sb = new StringBuilder("Split documents with following ids were deleted as part of GC \n");
        Joiner.on((String)StandardSystemProperty.LINE_SEPARATOR.value()).appendTo(sb, ids);
        LOG.debug(sb.toString());
    }

    private static String getID(BasicDBObject document) {
        return String.valueOf(document.get("_id"));
    }

    private MongoCollection<BasicDBObject> getNodeCollection() {
        return this.store.getDBCollection(Collection.NODES);
    }

    private class MongoSplitDocCleanUp
    extends SplitDocumentCleanUp {
        final Set<NodeDocument.SplitDocType> gcTypes;
        final RevisionVector sweepRevs;
        final long oldestRevTimeStamp;

        MongoSplitDocCleanUp(Set<NodeDocument.SplitDocType> gcTypes, RevisionVector sweepRevs, long oldestRevTimeStamp, VersionGarbageCollector.VersionGCStats stats) {
            super(MongoVersionGCSupport.this.store, stats, MongoVersionGCSupport.this.identifyGarbage(gcTypes, sweepRevs, oldestRevTimeStamp));
            this.gcTypes = gcTypes;
            this.sweepRevs = sweepRevs;
            this.oldestRevTimeStamp = oldestRevTimeStamp;
        }

        @Override
        protected void collectIdToBeDeleted(String id) {
        }

        @Override
        protected int deleteSplitDocuments() {
            Bson query = MongoVersionGCSupport.this.createQuery(this.gcTypes, this.sweepRevs, this.oldestRevTimeStamp);
            if (LOG.isDebugEnabled()) {
                MongoVersionGCSupport.this.logSplitDocIdsTobeDeleted(query);
            }
            return (int)MongoVersionGCSupport.this.getNodeCollection().deleteMany(query).getDeletedCount();
        }
    }
}

